/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment OpenGL ES-CM 1.1 plugin
 *
 * Copyright © 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#ifndef __PGM_GLES_BACKEND_H__
#define __PGM_GLES_BACKEND_H__

/* pgmglesbackend.h and pgmglescontext.h include eachother */
typedef struct _PgmGlesBackend      PgmGlesBackend;
typedef struct _PgmGlesBackendClass PgmGlesBackendClass;

#include <pgm/pgm.h>
#include "pgmglescontext.h"

G_BEGIN_DECLS

#define PGM_TYPE_GLES_BACKEND (pgm_gles_backend_get_type ())
#define PGM_GLES_BACKEND(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), PGM_TYPE_GLES_BACKEND, PgmGlesBackend))
#define PGM_GLES_BACKEND_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), PGM_TYPE_GLES_BACKEND, PgmGlesBackendClass))
#define PGM_IS_GLES_BACKEND(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), PGM_TYPE_GLES_BACKEND))
#define PGM_IS_GLES_BACKEND_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), PGM_TYPE_GLES_BACKEND))
#define PGM_GLES_BACKEND_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj), PGM_TYPE_GLES_BACKEND, PgmGlesBackendClass))

struct _PgmGlesBackend {
  GstObject parent;

  PgmGlesContext *context;
};

struct _PgmGlesBackendClass {
  GstObjectClass parent_class;

  /* virtual methods for subclasses */

  /* Create the window */
  gboolean (*create_window)         (PgmGlesBackend *glesbackend);

  /* Destroy the window */
  gboolean (*destroy_window)        (PgmGlesBackend *glesbackend);

  /* Swap the buffers */
  void     (*swap_buffers)          (PgmGlesBackend *glesbackend);

  /* Get the address of the OpenGL ES extension function named proc_name */
  gpointer (*get_proc_address)      (PgmGlesBackend *glesbackend,
                                     const gchar *proc_name);

  /* Show/Hide (map/unmap) the window */
  gboolean (*set_visibility)        (PgmGlesBackend *glesbackend,
                                     gboolean visible);

  /* Retrieve the size of the physical screen in millimeters */
  void     (*get_screen_size_mm)    (PgmGlesBackend *glesbackend,
                                     gint *width,
                                     gint *height);

  /* Retrieve the desktop resolution */
  void     (*get_screen_resolution) (PgmGlesBackend *glesbackend,
                                     gint *width,
                                     gint *height);
  /* Set the screen resolution */
  void     (*set_screen_resolution) (PgmGlesBackend *glesbackend,
                                     gint width,
                                     gint height);
};

GType    pgm_gles_backend_get_type              (void) G_GNUC_CONST;

void     pgm_gles_backend_register              (GTypeModule *module);

gboolean pgm_gles_backend_create_window         (PgmGlesBackend *glesbackend);

gboolean pgm_gles_backend_destroy_window        (PgmGlesBackend *glesbackend);

void     pgm_gles_backend_swap_buffers          (PgmGlesBackend *glesbackend);

gpointer pgm_gles_backend_get_proc_address      (PgmGlesBackend *glesbackend,
                                                 const gchar *proc_name);

gboolean pgm_gles_backend_set_visibility        (PgmGlesBackend *glesbackend,
                                                 gboolean visible);

void     pgm_gles_backend_get_screen_size_mm    (PgmGlesBackend *glesbackend,
                                                 gint *width,
                                                 gint *height);

void     pgm_gles_backend_get_screen_resolution (PgmGlesBackend *glesbackend,
                                                 gint *width,
                                                 gint *height);

void     pgm_gles_backend_set_screen_resolution (PgmGlesBackend *glesbackend,
                                                 gint width,
                                                 gint height);


G_END_DECLS

#endif /* __PGM_GLES_BACKEND_H__ */
