# -*- coding: UTF-8 -*-
#############################################
## (C)opyright by Dirk Holtwick, 2008      ##
## All rights reserved                     ##
#############################################

__version__ = "$Revision: 103 $"
__author__  = "$Author: holtwick $"
__date__    = "$Date: 2007-10-31 17:08:54 +0100 (Mi, 31 Okt 2007) $"
__svnid__   = "$Id: pisa.py 103 2007-10-31 16:08:54Z holtwick $"

import ho.pisa as pisa
import StringIO

import logging
log = logging.getLogger("ho.pisa.wsgi")

class Filter(object):

    def __init__(self, app):
        self.app = app

    def __call__(self, environ, start_response):
        script_name = environ.get('SCRIPT_NAME', '')
        path_info = environ.get('PATH_INFO', '')
        sent = []
        written_response = StringIO.StringIO()
        def replacement_start_response(status, headers, exc_info=None):
            if not self.should_filter(status, headers):
                return start_response(status, headers, exc_info)
            else:
                sent[:] = [status, headers, exc_info]
                return written_response.write
        app_iter = self.app(environ, replacement_start_response)
        if not sent:
            return app_iter
        status, headers, exc_info = sent
        try:
            for chunk in app_iter:
                written_response.write(chunk)
        finally:
            if hasattr(app_iter, 'close'):
                app_iter.close()
        body = written_response.getvalue()
        status, headers, body = self.filter(
            script_name, path_info, environ, status, headers, body)
        start_response(status, headers, exc_info)
        return [body]

    def should_filter(self, status, headers):
        print headers
    
    def filter(self, status, headers, body):
        raise NotImplementedError


class HTMLFilter(Filter):

    def should_filter(self, status, headers):
        if not status.startswith('200'):
            return False
        for name, value in headers:
            if name.lower() == 'content-type':
                return value.startswith('text/html')
        return False
    
class PisaMiddleware(HTMLFilter):
                  
    def filter(self, 
            script_name, 
            path_info, 
            environ,
            status, 
            headers, 
            body): 
        topdf = environ.get("pisa.topdf", "")        
        if topdf:            
            dst = StringIO.StringIO()
            result = pisa.CreatePDF(
                body,
                dst,
                show_error_as_pdf=True,
                )
            headers = [
                ("content-type", "application/pdf"),
                ("content-disposition", "attachment; filename=" + topdf)
                ] 
            body = dst.getvalue()              
        return status, headers, body
        