#! /usr/bin/perl -w

use strict;
use warnings;

use DBI;

require 'Classes/Filter.pm';

require 'Functions/config.pl';
require 'Functions/db.pl';
require 'Functions/FilterList.pl';

package main;

if ( ! $ARGV[0] ) {die( "usage: perl crontab/toady.pl Filter.flt\n" );};

our %conf = ();	# configuration directives

LoadConfig();

  # Open the DB connection :
our $dbh = DB_Open();

while( my $FilterFile = shift )
{
	if ( -f $FilterFile )
	{
		my $Filter = Filter->new();
		$Filter->load( $FilterFile );

		my $TotalResultNb = $Filter->count();

		if ( $TotalResultNb > 0 )
		{
			print " $TotalResultNb alerts match the following rule/filter : $FilterFile\n";
			print ' '.( $Filter->comment() )."\n";
		}
	}
	else
	{
		print " Filter not found : $FilterFile\n";
	}
}
