/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.DepFind;
import com.tonicsystems.jarjar.IoUtils;
import com.tonicsystems.jarjar.MainProcessor;
import com.tonicsystems.jarjar.RulesFileParser;
import com.tonicsystems.jarjar.StringDumper;
import com.tonicsystems.jarjar.TextDepHandler;
import com.tonicsystems.jarjar.ext_util.RuntimeIOException;
import com.tonicsystems.jarjar.ext_util.StandaloneJarProcessor;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class Main {
    public static final int STYLE_SIMPLE = 0;
    private static final String HELP;
    private boolean verbose;
    private List patterns;
    private int level = 0;
    private int style = 0;
    static /* synthetic */ Class array$Ljava$lang$String;

    public static void main(String[] args) throws Exception {
        Main main = new Main();
        if (args.length > 0) {
            String command = args[0];
            Method[] methods = main.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().equals(command)) continue;
                String[] remaining = new String[args.length - 1];
                System.arraycopy(args, 1, remaining, 0, remaining.length);
                try {
                    method.invoke((Object)main, Main.bindParameters(method, remaining));
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof IllegalArgumentException) {
                        System.err.println("Syntax error: " + cause.getMessage());
                    }
                    if (cause instanceof Exception) {
                        throw (Exception)cause;
                    }
                    throw e;
                }
                return;
            }
        }
        main.help();
    }

    private static Object[] bindParameters(Method method, String[] args) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        Class<?>[] parameterTypes = method.getParameterTypes();
        int len = parameterTypes.length;
        for (int i = 0; i < len; ++i) {
            Class<?> type = parameterTypes[i];
            int remaining = Math.max(0, args.length - i);
            if (type.equals(array$Ljava$lang$String == null ? Main.class$("[Ljava.lang.String;") : array$Ljava$lang$String)) {
                String[] rest = new String[remaining];
                System.arraycopy(args, 1, rest, 0, remaining);
                parameters.add(rest);
                continue;
            }
            if (remaining > 0) {
                parameters.add(Main.convertParameter(args[i], parameterTypes[i]));
                continue;
            }
            parameters.add(null);
        }
        return parameters.toArray();
    }

    private static Object convertParameter(String arg, Class type) {
        if (type.equals(String.class)) {
            return arg;
        }
        if (type.equals(Integer.class)) {
            return Integer.valueOf(arg, 10);
        }
        if (type.equals(File.class)) {
            return new File(arg);
        }
        throw new UnsupportedOperationException("Unknown type " + type);
    }

    public void help() {
        System.err.print(HELP);
    }

    public void strings(String cp) throws IOException {
        if (cp == null) {
            throw new IllegalArgumentException("cp is required");
        }
        new StringDumper().run(cp, new PrintWriter(System.out));
    }

    public void find(String level, String cp1, String cp2) throws IOException {
        int levelFlag;
        if (level == null || cp1 == null) {
            throw new IllegalArgumentException("level and cp1 are required");
        }
        if (cp2 == null) {
            cp2 = cp1;
        }
        if ("class".equals(level)) {
            levelFlag = 0;
        } else if ("jar".equals(level)) {
            levelFlag = 1;
        } else {
            throw new IllegalArgumentException("unknown level " + level);
        }
        PrintWriter w = new PrintWriter(System.out);
        TextDepHandler handler = new TextDepHandler(w, levelFlag);
        new DepFind().run(cp1, cp2, handler);
        w.flush();
    }

    public void process(File rulesFile, File inJar, File outJar) throws IOException {
        if (rulesFile == null || inJar == null || outJar == null) {
            throw new IllegalArgumentException("rulesFile, inJar, and outJar are required");
        }
        boolean verbose = false;
        List rules = RulesFileParser.parse(rulesFile);
        MainProcessor proc = new MainProcessor(rules, verbose, true);
        StandaloneJarProcessor.run(inJar, outJar, proc);
        proc.strip(outJar);
    }

    static {
        try {
            HELP = IoUtils.readIntoString(Main.class.getResourceAsStream("help.txt"));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}

