//
//  PRCCurves.m
//  PRICE
//
//  Created by Riccardo Mottola on 7 August 2011.
//  Copyright 2011 Riccardo Mottola. All rights reserved.
//
// This application is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#import "MyDocument.h"
#import "PRCCurves.h"
#import "PRCurves.h"


@implementation PRCCurves

- (id)init
{
  if ((self = [super init]))
    {
      filter = [[PRCurves alloc] init];
      
    }
  return self;
}


- (IBAction)showFilter:(id)sender
{
  [super showFilter:sender];
  
  if (!curvesWindow)
    [NSBundle loadNibNamed:@"Curves" owner:self];
  [curvesView setFilterController: self];
  
  
  currPath = [curvesView luminancePath];
//  [self curvesReset: self];
  PRImage *image = [[[NSDocumentController sharedDocumentController] currentDocument] activeImage];
  [curvesView calculateHistogram: image];

  [curvesWindow makeKeyAndOrderFront:nil];
  [self parametersChanged:self];
}

- (NSArray *)encodeParameters
{
  NSArray           *parameters;
  NSMutableArray    *arrayL;
  NSMutableArray    *arrayR;
  NSMutableArray    *arrayG;
  NSMutableArray    *arrayB;
  unsigned i;

  if ([curvesView isColor])
    {
      arrayR = [[NSMutableArray alloc] initWithCapacity: UCHAR_MAX];
      arrayG = [[NSMutableArray alloc] initWithCapacity: UCHAR_MAX];
      arrayB = [[NSMutableArray alloc] initWithCapacity: UCHAR_MAX];
  
      for (i = 0; i <= UCHAR_MAX; i++)
	{
	  [arrayR addObject: [NSNumber numberWithUnsignedInt: curvesView->funL[i]]];
	  [arrayG addObject: [NSNumber numberWithUnsignedInt: curvesView->funL[i]]];
	  [arrayB addObject: [NSNumber numberWithUnsignedInt: curvesView->funL[i]]];
	}  
      /* encode parameters */
      parameters = [NSArray arrayWithObjects:
			      arrayR,
			    arrayG,
			    arrayB,
			    nil];
    }
  else
    {
      arrayL = [[NSMutableArray alloc] initWithCapacity: UCHAR_MAX];
  
      for (i = 0; i <= UCHAR_MAX; i++)
	[arrayL addObject: [NSNumber numberWithUnsignedInt: curvesView->funL[i]]];
  
      /* encode parameters */
      parameters = [NSArray arrayWithObjects:
			      arrayL,
			    nil];
    }

  return parameters;
}

- (void)closeFilterPanel
{
  [curvesWindow performClose:nil];
}

- (IBAction)parametersChanged:(id)sender
{
  [curvesView calculateTransformedHistograms];

  [super parametersChanged: sender];
  [curvesView setNeedsDisplay: YES];
}

- (IBAction)curvesReset:(id)sender
{
  [currPath removeAllPoints];
  
  [currPath moveToPoint: NSMakePoint(0, 0)];
  [currPath curveToPoint: NSMakePoint(255, 255) controlPoint1: NSMakePoint(10, 10) controlPoint2: NSMakePoint(245, 245)];
}

- (IBAction)setBlackPoint:(id)sender
{
  int point;
  
  point = [sender intValue];
  if (point > 254)
    point = 254;
  else if (point < 0)
    point = 0;
  else if (point >= [whitePointField intValue])
    point = [whitePointField intValue];
  [blackPointField setIntValue: point];
  [blackPointStepper setIntValue: point];
  NSLog(@"black point: %d", point);
  
  [curvesView setBlackPoint: point];
  [self parametersChanged:sender];
}

- (IBAction)setWhitePoint:(id)sender
{
  int point;
  
  point = [sender intValue];
  if (point > 255)
    point = 255;
  else if (point < 1)
    point = 1;
  else if (point <= [blackPointField intValue])
    point = [blackPointField intValue];
  [whitePointField setIntValue: point];
  [whitePointStepper setIntValue: point];
  NSLog(@"white point: %d", point);  

  [curvesView setWhitePoint: point];
  [self parametersChanged:sender];
}


@end
