# Beaker Libraries

Engineering at Puppet Labs has written several libraries that extends the functionality provided by Beaker.

To learn how to create beaker libraries, see the [Beaker-Template](https://github.com/puppetlabs/beaker-template/blob/master/README.md) documentation.

| Name               | Description                                                         | Docs                                                            |
|:-------------------|:--------------------------------------------------------------------|:----------------------------------------------------------------|
| Master Manipulator | Easy DSL extension for changing configuration on a Puppet Master    | [Github Repo](https://github.com/puppetlabs/master_manipulator) |
| beaker_windows     | Useful helpers for testing on Windows hosts                         | [Github Repo](https://github.com/puppetlabs/beaker_windows)     |
| Puppet Install Helper | Use environment variables for choosing which puppet version to install | [Github Repo](https://github.com/puppetlabs/beaker-puppet_install_helper) |
| testmode_switcher   | [prototype] run your puppet module tests in master/agent, apply or local mode | [Github Repo](https://github.com/puppetlabs/beaker-testmode_switcher)     |
| beaker-hostgenerator | Generates Beaker host files | [Github Repo](https://github.com/puppetlabs/beaker-hostgenerator/) |
| beaker-answers | Generates answers for Puppet Enterprise installation | [Github Repo](https://github.com/puppetlabs/beaker-answers/) |
| beaker-pe | Adds helper methods for Puppet Enterprise specific tasks | [Github Repo](https://github.com/puppetlabs/beaker-pe/) |
| beaker-http | Adds ability to dispatch http traffic from the coordinator | [Github Repo](https://github.com/puppetlabs/beaker-http/) |
| Beaker Rubymine Plugin | An IntelliJ IDEA plugin making Beaker test runs a native IDE experience | [Github Repo](https://github.com/samwoods1/BeakerRubyMinePlugin) |
| beaker-rspec | A bridge between beaker itself and [rspec](https://github.com/rspec/rspec); also integrates [serverspec](http://serverspec.org/) | [Github Repo](https://github.com/puppetlabs/beaker-rspec/) |
| beaker-puppet | Adds helper & install methods for Puppet-specific tasks | [Github Repo](https://github.com/puppetlabs/beaker-puppet/)

