# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Optional, TYPE_CHECKING, cast
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.settings import settings
from azure.mgmt.core import ARMPipelineClient
from azure.mgmt.core.policies import ARMAutoResourceProviderRegistrationPolicy
from azure.mgmt.core.tools import get_arm_endpoints

from ._configuration import WorkloadOrchestrationMgmtClientConfiguration
from ._utils.serialization import Deserializer, Serializer
from .operations import (
    ConfigTemplateVersionsOperations,
    ConfigTemplatesOperations,
    ContextsOperations,
    DiagnosticsOperations,
    DynamicSchemaVersionsOperations,
    DynamicSchemasOperations,
    ExecutionsOperations,
    InstanceHistoriesOperations,
    InstancesOperations,
    JobsOperations,
    SchemaReferencesOperations,
    SchemaVersionsOperations,
    SchemasOperations,
    SiteReferencesOperations,
    SolutionTemplateVersionsOperations,
    SolutionTemplatesOperations,
    SolutionVersionsOperations,
    SolutionsOperations,
    TargetsOperations,
    WorkflowVersionsOperations,
    WorkflowsOperations,
)

if TYPE_CHECKING:
    from azure.core.credentials import TokenCredential


class WorkloadOrchestrationMgmtClient:  # pylint: disable=too-many-instance-attributes
    """Microsoft.Edge Resource Provider management API.

    :ivar dynamic_schemas: DynamicSchemasOperations operations
    :vartype dynamic_schemas: azure.mgmt.workloadorchestration.operations.DynamicSchemasOperations
    :ivar schemas: SchemasOperations operations
    :vartype schemas: azure.mgmt.workloadorchestration.operations.SchemasOperations
    :ivar schema_versions: SchemaVersionsOperations operations
    :vartype schema_versions: azure.mgmt.workloadorchestration.operations.SchemaVersionsOperations
    :ivar solution_versions: SolutionVersionsOperations operations
    :vartype solution_versions:
     azure.mgmt.workloadorchestration.operations.SolutionVersionsOperations
    :ivar jobs: JobsOperations operations
    :vartype jobs: azure.mgmt.workloadorchestration.operations.JobsOperations
    :ivar targets: TargetsOperations operations
    :vartype targets: azure.mgmt.workloadorchestration.operations.TargetsOperations
    :ivar dynamic_schema_versions: DynamicSchemaVersionsOperations operations
    :vartype dynamic_schema_versions:
     azure.mgmt.workloadorchestration.operations.DynamicSchemaVersionsOperations
    :ivar schema_references: SchemaReferencesOperations operations
    :vartype schema_references:
     azure.mgmt.workloadorchestration.operations.SchemaReferencesOperations
    :ivar solutions: SolutionsOperations operations
    :vartype solutions: azure.mgmt.workloadorchestration.operations.SolutionsOperations
    :ivar solution_template_versions: SolutionTemplateVersionsOperations operations
    :vartype solution_template_versions:
     azure.mgmt.workloadorchestration.operations.SolutionTemplateVersionsOperations
    :ivar solution_templates: SolutionTemplatesOperations operations
    :vartype solution_templates:
     azure.mgmt.workloadorchestration.operations.SolutionTemplatesOperations
    :ivar instances: InstancesOperations operations
    :vartype instances: azure.mgmt.workloadorchestration.operations.InstancesOperations
    :ivar instance_histories: InstanceHistoriesOperations operations
    :vartype instance_histories:
     azure.mgmt.workloadorchestration.operations.InstanceHistoriesOperations
    :ivar config_templates: ConfigTemplatesOperations operations
    :vartype config_templates:
     azure.mgmt.workloadorchestration.operations.ConfigTemplatesOperations
    :ivar config_template_versions: ConfigTemplateVersionsOperations operations
    :vartype config_template_versions:
     azure.mgmt.workloadorchestration.operations.ConfigTemplateVersionsOperations
    :ivar workflows: WorkflowsOperations operations
    :vartype workflows: azure.mgmt.workloadorchestration.operations.WorkflowsOperations
    :ivar workflow_versions: WorkflowVersionsOperations operations
    :vartype workflow_versions:
     azure.mgmt.workloadorchestration.operations.WorkflowVersionsOperations
    :ivar executions: ExecutionsOperations operations
    :vartype executions: azure.mgmt.workloadorchestration.operations.ExecutionsOperations
    :ivar diagnostics: DiagnosticsOperations operations
    :vartype diagnostics: azure.mgmt.workloadorchestration.operations.DiagnosticsOperations
    :ivar contexts: ContextsOperations operations
    :vartype contexts: azure.mgmt.workloadorchestration.operations.ContextsOperations
    :ivar site_references: SiteReferencesOperations operations
    :vartype site_references: azure.mgmt.workloadorchestration.operations.SiteReferencesOperations
    :param credential: Credential used to authenticate requests to the service. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription. The value must be an UUID. Required.
    :type subscription_id: str
    :param base_url: Service host. Default value is None.
    :type base_url: str
    :keyword api_version: The API version to use for this operation. Default value is "2025-06-01".
     Note that overriding this default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self, credential: "TokenCredential", subscription_id: str, base_url: Optional[str] = None, **kwargs: Any
    ) -> None:
        _endpoint = "{endpoint}"
        _cloud = kwargs.pop("cloud_setting", None) or settings.current.azure_cloud  # type: ignore
        _endpoints = get_arm_endpoints(_cloud)
        if not base_url:
            base_url = _endpoints["resource_manager"]
        credential_scopes = kwargs.pop("credential_scopes", _endpoints["credential_scopes"])
        self._config = WorkloadOrchestrationMgmtClientConfiguration(
            credential=credential,
            subscription_id=subscription_id,
            base_url=cast(str, base_url),
            credential_scopes=credential_scopes,
            **kwargs
        )

        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                ARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: ARMPipelineClient = ARMPipelineClient(base_url=cast(str, _endpoint), policies=_policies, **kwargs)

        self._serialize = Serializer()
        self._deserialize = Deserializer()
        self._serialize.client_side_validation = False
        self.dynamic_schemas = DynamicSchemasOperations(self._client, self._config, self._serialize, self._deserialize)
        self.schemas = SchemasOperations(self._client, self._config, self._serialize, self._deserialize)
        self.schema_versions = SchemaVersionsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.solution_versions = SolutionVersionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.jobs = JobsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.targets = TargetsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.dynamic_schema_versions = DynamicSchemaVersionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.schema_references = SchemaReferencesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.solutions = SolutionsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.solution_template_versions = SolutionTemplateVersionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.solution_templates = SolutionTemplatesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.instances = InstancesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.instance_histories = InstanceHistoriesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.config_templates = ConfigTemplatesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.config_template_versions = ConfigTemplateVersionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workflows = WorkflowsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.workflow_versions = WorkflowVersionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.executions = ExecutionsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.diagnostics = DiagnosticsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.contexts = ContextsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.site_references = SiteReferencesOperations(self._client, self._config, self._serialize, self._deserialize)

    def send_request(self, request: HttpRequest, *, stream: bool = False, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client.send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        request_copy.url = self._client.format_url(request_copy.url, **path_format_arguments)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> Self:
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details: Any) -> None:
        self._client.__exit__(*exc_details)
