/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef MESSAGEFILTER_H
#define MESSAGEFILTER_H

#include <QList>
#include <QSettings>

class FiltrationRule;
class Message;

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class MessageFilter
{
  private:
    QList<FiltrationRule*> m_whiteRules;
    QList<FiltrationRule*> m_blackRules;

  public:
    MessageFilter();
    ~MessageFilter();

    void addBlackRule(FiltrationRule* rule) {if(!m_blackRules.contains(rule)) m_blackRules.append(rule);}
    void addWhiteRule(FiltrationRule* rule) {if(!m_whiteRules.contains(rule)) m_whiteRules.append(rule);}

    QList<FiltrationRule*> blackRules(){return m_blackRules;}
    QList<FiltrationRule*> whiteRules(){return m_whiteRules;}

    void removeRule(FiltrationRule* rule);

    bool isGoodMessage(Message*);
    bool isBadMessage (Message*);

    /**
     * @brief Accepts or rejects message based on filtration rules
     * @param  msg message to filter
     * @param  blacklist is filtration going by blacklist or whitelist
     */
    bool validateMessage(Message* msg, bool blacklist = true);

    void save(QSettings*) const;
    void load(QSettings*);
};

#endif
