/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(JAVASCRIPT_DEBUGGER)

#include "JSScriptProfile.h"

#include "JSScriptProfileNode.h"
#include "KURL.h"
#include "ScriptProfile.h"
#include "ScriptProfileNode.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSScriptProfile);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSScriptProfileTableValues[4] =
{
    { "title", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScriptProfileTitle), (intptr_t)0 THUNK_GENERATOR(0) },
    { "uid", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScriptProfileUid), (intptr_t)0 THUNK_GENERATOR(0) },
    { "head", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScriptProfileHead), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSScriptProfileTable = { 8, 7, JSScriptProfileTableValues, 0 };
/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSScriptProfilePrototypeTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSScriptProfilePrototypeTable = { 1, 0, JSScriptProfilePrototypeTableValues, 0 };
const ClassInfo JSScriptProfilePrototype::s_info = { "ScriptProfilePrototype", &JSC::JSObjectWithGlobalObject::s_info, &JSScriptProfilePrototypeTable, 0 };

JSObject* JSScriptProfilePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSScriptProfile>(exec, globalObject);
}

const ClassInfo JSScriptProfile::s_info = { "ScriptProfile", &JSDOMWrapper::s_info, &JSScriptProfileTable, 0 };

JSScriptProfile::JSScriptProfile(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<ScriptProfile> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSScriptProfile::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSScriptProfilePrototype(exec->globalData(), globalObject, JSScriptProfilePrototype::createStructure(globalObject->globalData(), globalObject->objectPrototype()));
}

bool JSScriptProfile::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSScriptProfile, Base>(exec, &JSScriptProfileTable, this, propertyName, slot);
}

bool JSScriptProfile::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSScriptProfile, Base>(exec, &JSScriptProfileTable, this, propertyName, descriptor);
}

JSValue jsScriptProfileTitle(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSScriptProfile* castedThis = static_cast<JSScriptProfile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ScriptProfile* imp = static_cast<ScriptProfile*>(castedThis->impl());
    JSValue result = jsString(exec, imp->title());
    return result;
}


JSValue jsScriptProfileUid(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSScriptProfile* castedThis = static_cast<JSScriptProfile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ScriptProfile* imp = static_cast<ScriptProfile*>(castedThis->impl());
    JSValue result = jsNumber(imp->uid());
    return result;
}


JSValue jsScriptProfileHead(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSScriptProfile* castedThis = static_cast<JSScriptProfile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ScriptProfile* imp = static_cast<ScriptProfile*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->head()));
    return result;
}


JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, ScriptProfile* impl)
{
    return wrap<JSScriptProfile>(exec, globalObject, impl);
}

ScriptProfile* toScriptProfile(JSC::JSValue value)
{
    return value.inherits(&JSScriptProfile::s_info) ? static_cast<JSScriptProfile*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(JAVASCRIPT_DEBUGGER)
