/* ============================================================
* QuiteRSS is a open-source cross-platform RSS/Atom news feeds reader
* Copyright (C) 2011-2013 QuiteRSS Team <quiterssteam@gmail.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
* ============================================================ */
#include "aboutdialog.h"
#include "VersionNo.h"

#if defined(Q_OS_WIN) || defined(Q_OS_OS2)
#if QT_VERSION >= 0x050100
#include <sqlite_qt51x/sqlite3.h>
#elif QT_VERSION >= 0x040800
#include <sqlite_qt48x/sqlite3.h>
#else
#include <sqlite_qt47x/sqlite3.h>
#endif
#else
#include <sqlite3.h>
#endif
#include <qyursqltreeview.h>
#ifdef HAVE_QT5
#include <QWebPage>
#else
#include <qwebkitversion.h>
#endif

AboutDialog::AboutDialog(const QString &lang, QWidget *parent) :
  Dialog(parent, Qt::MSWindowsFixedSizeDialogHint)
{
  setWindowTitle(tr("About"));
  setWindowFlags (windowFlags() & ~Qt::WindowContextHelpButtonHint);
  setObjectName("AboutDialog");
  setMinimumWidth(480);

  QTabWidget *tabWidget = new QTabWidget();

  QyurSqlTreeView treeView;

  QString revisionStr;
  if (QString("%1").arg(VCS_REVISION) != "0") {
      revisionStr = "<BR>" + tr("Revision") + " " + QString("%1").arg(VCS_REVISION);
  }
  QString appInfo =
      "<html><style>a { color: blue; text-decoration: none; }</style><body>"
      "<CENTER>"
      "<IMG SRC=\":/images/images/logo.png\">"
      "<BR><IMG SRC=\":/images/images/logo_text.png\">"
      "<P>"
      + tr("Version") + " " + "<B>" + QString(STRPRODUCTVER) + "</B>" + QString(" (%1)").arg(STRDATE)
      + revisionStr
      + "</P>"
      + "<BR>"
      + tr("QuiteRSS is a open-source cross-platform RSS/Atom news reader")
      + "<P>" + tr("Includes:")
      + QString(" Qt-%1, SQLite-%2, QyurSqlTreeView-%3, WebKit-%4").
      arg(QT_VERSION_STR).arg(SQLITE_VERSION).
      arg(treeView.metaObject()->classInfo(treeView.metaObject()->indexOfClassInfo("Version")).value()).
      arg(qWebKitVersion())
      + "</P>"
      + QString("<a href=\"%1\">%1</a>").arg("http://quiterss.org") +
      "<P>Copyright &copy; 2011-2013 QuiteRSS Team "
      + QString("<a href=\"%1\">E-mail</a>").arg("mailto:quiterssteam@gmail.com") + "</P>"
      "</CENTER></body></html>";
  QLabel *infoLabel = new QLabel(appInfo);
  infoLabel->setOpenExternalLinks(true);
  infoLabel->setTextInteractionFlags(Qt::TextBrowserInteraction);

  QHBoxLayout *mainLayout = new QHBoxLayout();
  mainLayout->addWidget(infoLabel);
  QWidget *mainWidget = new QWidget();
  mainWidget->setLayout(mainLayout);

  QTextEdit *authorsTextEdit = new QTextEdit(this);
  authorsTextEdit->setReadOnly(true);
  QFile file;
  file.setFileName(":/file/AUTHORS");
  file.open(QFile::ReadOnly);
  authorsTextEdit->setText(QString::fromUtf8(file.readAll()));
  file.close();

  QHBoxLayout *authorsLayout = new QHBoxLayout();
  authorsLayout->addWidget(authorsTextEdit);
  QWidget *authorsWidget = new QWidget();
  authorsWidget->setLayout(authorsLayout);

  QTextBrowser *historyTextBrowser = new QTextBrowser();
  historyTextBrowser->setOpenExternalLinks(true);
  if (lang.contains("ru", Qt::CaseInsensitive))
    file.setFileName(":/file/HISTORY_RU");
  else
    file.setFileName(":/file/HISTORY_EN");
  file.open(QFile::ReadOnly);
  historyTextBrowser->setHtml(QString::fromUtf8(file.readAll()));
  file.close();

  QHBoxLayout *historyLayout = new QHBoxLayout();
  historyLayout->addWidget(historyTextBrowser);
  QWidget *historyWidget = new QWidget();
  historyWidget->setLayout(historyLayout);

  QTextEdit *licenseTextEdit = new QTextEdit();
  licenseTextEdit->setReadOnly(true);
  file.setFileName(":/file/COPYING");
  file.open(QFile::ReadOnly);
  QString str = QString(QString::fromUtf8(file.readAll())).section("-----", 1, 1);
  licenseTextEdit->setText(str);
  file.close();

  QHBoxLayout *licenseLayout = new QHBoxLayout();
  licenseLayout->addWidget(licenseTextEdit);

  QWidget *licenseWidget = new QWidget();
  licenseWidget->setLayout(licenseLayout);

  tabWidget->addTab(mainWidget, tr("Version"));
  tabWidget->addTab(authorsWidget, tr("Authors"));
  tabWidget->addTab(historyWidget, tr("History"));
  tabWidget->addTab(licenseWidget, tr("License"));

  pageLayout->addWidget(tabWidget);

  buttonBox->addButton(QDialogButtonBox::Close);
}
