% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callAlterations.R
\name{callAlterationsFromSegmentation}
\alias{callAlterationsFromSegmentation}
\title{Calling of amplifications and deletions from segmentations}
\usage{
callAlterationsFromSegmentation(
  sampleid,
  chr,
  start,
  end,
  num.mark = NA,
  seg.mean,
  C,
  interval.file,
  fun.focal = findFocal,
  args.focal = list(),
  ...
)
}
\arguments{
\item{sampleid}{The sampleid column in the segmentation file.}

\item{chr}{The chromosome column.}

\item{start}{The start positions of the segments.}

\item{end}{The end positions of the segments.}

\item{num.mark}{Optionally, the number of probes or markers in each segment.}

\item{seg.mean}{The segment mean.}

\item{C}{The segment integer copy number.}

\item{interval.file}{A mapping file that assigns GC content and gene symbols
to each exon in the coverage files. Used for generating gene-level calls.
First column in format CHR:START-END. Second column GC content (0 to 1).
Third column gene symbol. This file is generated with the
\code{\link{preprocessIntervals}} function.}

\item{fun.focal}{Function for identifying focal amplifications. Defaults to
\code{\link{findFocal}}.}

\item{args.focal}{Arguments for focal amplification function.}

\item{\dots}{Arguments passed to \code{\link{callAlterations}}.}
}
\value{
A list of \code{\link{callAlterations}} \code{data.frame} objects,
one for each sample.
}
\description{
This function can be used to obtain gene-level copy number calls from
segmentations. This is useful for comparing PureCN's segmentations with
segmentations obtained by different tools on the gene-level.  Segmentation
file can contain multiple samples.
}
\examples{

data(purecn.example.output)
seg <- purecn.example.output$results[[1]]$seg
interval.file <- system.file("extdata", "example_intervals.txt",
        package = "PureCN")

calls <- callAlterationsFromSegmentation(sampleid = seg$ID, chr = seg$chrom,
    start = seg$loc.start, end = seg$loc.end, num.mark = seg$num.mark,
    seg.mean = seg$seg.mean, C = seg$C, interval.file = interval.file)

}
\author{
Markus Riester
}
