% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5O.R
\name{H5Ocopy}
\alias{H5Ocopy}
\title{Copies an HDF5 object}
\usage{
H5Ocopy(h5loc, name, h5loc_dest, name_dest, obj_cpy_pl = NULL, lcpl = NULL)
}
\arguments{
\item{h5loc}{An object of class \linkS4class{H5IdComponent} representing an open
HDF5 object where the source obiect should be copied from.}

\item{name}{Character vector of length 1, giving the name of the source object
to be copied.}

\item{h5loc_dest}{An object of class \linkS4class{H5IdComponent} representing an open
HDF5 object where the new copy should be created.}

\item{name_dest}{Character vector of length 1, giving the name of the new object
to be created.}

\item{obj_cpy_pl, lcpl}{\linkS4class{H5IdComponent} objects representing object copy and link creation property lists
respectively.  If left as \code{NULL} the default values for these will be used.}
}
\description{
Copies an HDF5 object
}
\examples{

## Create a temporary copy of an example file check the contents
example_file <- system.file("testfiles", "h5ex_t_array.h5", package="rhdf5")
file.copy(example_file, tempdir())
h5_file <- file.path(tempdir(), "h5ex_t_array.h5")
h5ls(h5_file)

## open the example file and create a new, empty, file
fid1 <- H5Fopen( h5_file )
h5_file2 <- tempfile(fileext = ".h5")
fid2 <- H5Fcreate( h5_file2 )

## We can copy a dataset inside the same file
H5Ocopy(h5loc = fid1, name = "DS1", h5loc_dest = fid1, name_dest = "DS2")
## Or to a different file
H5Ocopy(h5loc = fid1, name = "DS1", h5loc_dest = fid2, name_dest = "DS1_copy")

## if we want to create a new group hierarchy we can use a link creation property list
lcpl <- H5Pcreate("H5P_LINK_CREATE")
H5Pset_create_intermediate_group( lcpl, create_groups = TRUE )
H5Ocopy(h5loc = fid1, name = "DS1", h5loc_dest = fid2, 
        name_dest = "/foo/baa/DS1_nested", lcpl = lcpl)

## tidy up
H5Pclose(lcpl)
H5Fclose(fid1)
H5Fclose(fid2)

## Check we now have groups DS1 and DS2 in the original file
h5ls( h5_file )
## Check we have a copy of DS1 at the root and nests in the new file
h5ls( h5_file2 )

}
