% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5R.R
\name{H5Rdereference}
\alias{H5Rdereference}
\title{Open a reference object.}
\usage{
H5Rdereference(ref, h5loc)
}
\arguments{
\item{ref}{\code{H5ref} object containing the reference to be opened.}

\item{h5loc}{An \code{H5IdComponent} object representing the file containing the
referenced object.}
}
\value{
An object of class \code{H5IdComponent} representing the opened object
referenced by \code{ref}.  This should be closed with the appropriate function
e.g. \code{\link[=H5Dclose]{H5Dclose()}}, \code{\link[=H5Oclose]{H5Oclose()}}, etc. when no longer needed.
}
\description{
Given a reference and the file to which that reference applies,
\code{H5Rdeference()} will open the reference object and return an identifier.
}
\details{
If \code{ref} contains more than one reference, only the first reference
will be used.  It must be subset with \code{[} if one of the other stored
references should be opened.
}
