% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotExplanatoryVariables.R
\name{plotExplanatoryVariables}
\alias{plotExplanatoryVariables}
\title{Plot explanatory variables ordered by percentage of variance explained}
\usage{
plotExplanatoryVariables(
  object,
  nvars_to_plot = 10,
  min_marginal_r2 = 0,
  theme_size = 10,
  ...
)
}
\arguments{
\item{object}{A SingleCellExperiment object containing expression values and experimental information.
Alternatively, a matrix containing the output of \code{\link{getVarianceExplained}}.}

\item{nvars_to_plot}{Integer scalar specifying the number of variables with the greatest explanatory power to plot.
This can be set to \code{Inf} to show all variables.}

\item{min_marginal_r2}{Numeric scalar specifying the minimal value required for median marginal R-squared for a variable to be plotted. 
Only variables with a median marginal R-squared strictly larger than this value will be plotted.}

\item{theme_size}{Numeric scalar specifying the font size to use for the plotting theme}

\item{...}{Parameters to be passed to \code{\link{getVarianceExplained}}.}
}
\value{
A ggplot object.
}
\description{
Plot explanatory variables ordered by percentage of variance explained
}
\details{
A density plot is created for each variable, showing the distribution of R-squared across all genes.
Only the \code{nvars_to_plot} variables with the largest median R-squared across genes are shown.
Variables are also only shown if they have median R-squared values above \code{min_marginal_r2}.

If \code{object} is a SingleCellExperiment object, \code{\link{getVarianceExplained}} will be called to compute the variance in expression explained by each variable in each gene.
Users may prefer to run \code{\link{getVarianceExplained}} manually and pass the resulting matrix as \code{object}, in which case the R-squared values are used directly.
}
\examples{
example_sce <- mockSCE()
example_sce <- logNormCounts(example_sce)
plotExplanatoryVariables(example_sce)
}
