% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_smooths.R
\name{posterior_smooths.brmsfit}
\alias{posterior_smooths.brmsfit}
\alias{posterior_smooths}
\title{Posterior Predictions of Smooth Terms}
\usage{
\method{posterior_smooths}{brmsfit}(
  object,
  smooth,
  newdata = NULL,
  resp = NULL,
  dpar = NULL,
  nlpar = NULL,
  ndraws = NULL,
  draw_ids = NULL,
  ...
)

posterior_smooths(object, ...)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{smooth}{Name of a single smooth term for which predictions should
be computed.}

\item{newdata}{An optional \code{data.frame} for which to evaluate
predictions. If \code{NULL} (default), the original data of the model is
used. Only those variables appearing in the chosen \code{smooth} term are
required.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{dpar}{Optional name of a predicted distributional parameter.
If specified, expected predictions of this parameters are returned.}

\item{nlpar}{Optional name of a predicted non-linear parameter.
If specified, expected predictions of this parameters are returned.}

\item{ndraws}{Positive integer indicating how many posterior draws should
be used. If \code{NULL} (the default) all draws are used. Ignored if
\code{draw_ids} is not \code{NULL}.}

\item{draw_ids}{An integer vector specifying the posterior draws to be used.
If \code{NULL} (the default), all draws are used.}

\item{...}{Currently ignored.}
}
\value{
An S x N matrix, where S is the number of
  posterior draws and N is the number of observations.
}
\description{
Compute posterior predictions of smooth \code{s} and \code{t2} terms of
models fitted with \pkg{brms}.
}
\examples{
\dontrun{
set.seed(0)
dat <- mgcv::gamSim(1, n = 200, scale = 2)
fit <- brm(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat)
summary(fit)

newdata <- data.frame(x2 = seq(0, 1, 10))
str(posterior_smooths(fit, smooth = "s(x2)", newdata = newdata))
}

}
