% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors.R
\name{Error}
\alias{Error}
\title{Error class}
\arguments{
\item{behavior}{Behavior of the error. default: auto. See Details}

\item{message_template}{A message template. optional. use whisker
templating. names to use are: reason and status. use in template
like \code{\{\{reason\}\}} and  \code{\{\{status\}\}}. Note that
\code{\{\{message\}\}} that is used in \code{message_template_verbose}
will be ignored here.}

\item{call.}{(logical) indicating if the call should become part
of the error message. Default: \code{FALSE}}

\item{message_template_verbose}{A verbose message template. optional.
use whisker templating. names to use are: reason, status, message.
use in template like \code{\{\{reason\}\}}, \code{\{\{status\}\}}, and
\code{\{\{message\}\}}. Note that this is ignored here, but is
used in the \code{HTTP*} methods (e.g. \code{HTTPBadRequest})}

\item{muffle}{(logical) whether to not respond when status codes
in 1xx-3xx series. Default: \code{FALSE}}
}
\description{
Error class
}
\details{
\strong{Methods}
\itemize{
  \item \code{do(response, mssg)} {

  Execute condition, whether it be message, warning, or error.

  \itemize{
   \item response: is any response from \pkg{crul}, \pkg{curl}, or \pkg{httr}
  Execute condition, whether it be message, warning, error, or your
  own custom function. This method uses \code{message_template_verbose},
  and uses it's default value.
   \item mssg: character string message to include in call. ignored if
  template does not have a \code{message} entry
   }
  }

  \item \code{set_behavior(behavior)}

  Set behavior, same as setting behavior on initializing with \code{$new()}
}
}
\section{behavior parameter options}{

\itemize{
 \item stop - use \code{stop}
 \item warning - use \code{warning}
 \item message - use \code{message}
 \item auto - toggle between \code{stop} and \code{message} depending
 on the HTTP status code series. Defaults will be:
 \itemize{
  \item 1xx: \code{message}
  \item 2xx: \code{message}
  \item 3xx: \code{message}
  \item 4xx: \code{stop}
  \item 5xx: \code{stop}
 }
}

Of course, you can always override the defaults.
}

\examples{
Error$new()
# reset behavior
(z <- Error$new())
z$set_behavior("warning")
z

if (requireNamespace("crul")) {
 library("crul")
 res <- HttpClient$new("https://httpbin.org/status/418")$get()

 # stop
 (x <- Error$new(behavior = "stop"))
 \dontrun{x$do(res)}

 # warn
 (x <- Error$new(behavior = "warning"))
 x$do(res)

 # do vs. do_verbose
 x <- HTTPRequestURITooLong$new(behavior = "stop")
 res <- HttpClient$new("https://httpbin.org/status/414")$get()
 \dontrun{
 http414(res)
 ## with template
 http414(res, message_template = "{{status}}\n  --> {{reason}}")
 x$do(res)
 x$do_verbose(res)
 }

 # service unavailable
 x <- HTTPServiceUnavailable$new(behavior = "stop")
 res <- HttpClient$new("https://httpbin.org/status/503")$get()
 \dontrun{
 x$do(res)
 x$do_verbose(res)
 }

 # message template
 y <- Error$new(message_template = "{{reason}} ............ {{status}}")
 res <- HttpClient$new("https://httpbin.org/status/418")$get()
 \dontrun{
 y$do(res)
 }

 yy <- Error$new(message_template = "{{status}}\n  --> {{reason}}")
 yy$message_template
 \dontrun{
 yy$do(res)
 }

 ## with verbose message
 library(crul)
 res <- HttpClient$new("https://httpbin.org/status/401")$get()
 yy <- HTTPUnauthorized$new()
 zz <- HTTPUnauthorized$new(
   message_template = "HTTP({{status}}): {{reason}}\n  {{message}}"
 )
 yy$message_template; zz$message_template
 \dontrun{
 yy$do(res)
 zz$do(res)
 yy$do_verbose(res)
 zz$do_verbose(res)
 }

 yy <- Error$new(
   message_template = "HTTP({{status}}): {{reason}}\n  {{message}}"
 )
 yy$message_template
 \dontrun{yy$do(res)}

 # muffle responses
 (x <- Error$new(muffle = TRUE))
 res <- crul::HttpClient$new("https://httpbin.org/status/226")$get()
 z <- x$do(res)
 z
}
}
\seealso{
\code{\link[fauxpas]{http}}, \code{\link[fauxpas]{Error-Classes}}
}
