% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formattable.R
\name{formattable.POSIXlt}
\alias{formattable.POSIXlt}
\title{Create a formattable POSIXlt vector}
\usage{
\method{formattable}{POSIXlt}(
  x,
  ...,
  formatter = "format.POSIXlt",
  preproc = NULL,
  postproc = NULL
)
}
\arguments{
\item{x}{a vector of class \code{POSIXlt}.}

\item{...}{arguments to be passed to \code{formatter}.}

\item{formatter}{formatting function, \code{format.POSIXlt} in default.}

\item{preproc}{pre-processor function that prepares \code{x} for
formatting function.}

\item{postproc}{post-processor function that transforms formatted
output for printing.}
}
\value{
a \code{formattable} POSIXlt vector
}
\description{
Create a formattable POSIXlt vector
}
\examples{
times <- as.POSIXlt("2015-04-10 09:30:15") + 1:5
ftimes <- formattable(times, format = "\%Y\%m\%dT\%H\%M\%S")
ftimes
ftimes + 30
}
