% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/token-info.R
\name{token-info}
\alias{token-info}
\alias{token_userinfo}
\alias{token_email}
\alias{token_tokeninfo}
\title{Get info from a token}
\usage{
token_userinfo(token)

token_email(token)

token_tokeninfo(token)
}
\arguments{
\item{token}{A token with class \link[httr:Token-class]{Token2.0} or an object of
httr's class \code{request}, i.e. a token that has been prepared with
\code{\link[httr:config]{httr::config()}} and has a \link[httr:Token-class]{Token2.0} in the
\code{auth_token} component.}
}
\value{
A list containing:
\itemize{
\item \code{token_userinfo()}: user info
\item \code{token_email()}: user's email (obtained from a call to \code{token_userinfo()})
\item \code{token_tokeninfo()}: token info
}
}
\description{
These functions send the \code{token} to Google endpoints that return info about a
token or a user.
}
\details{
It's hard to say exactly what info will be returned by the "userinfo"
endpoint targetted by \code{token_userinfo()}. It depends on the token's scopes.
OAuth2 tokens obtained via the gargle package include the
\verb{https://www.googleapis.com/auth/userinfo.email} scope, which guarantees we
can learn the email associated with the token. If the token has the
\verb{https://www.googleapis.com/auth/userinfo.profile} scope, there will be even
more information available. But for a token with unknown or arbitrary scopes,
we can't make any promises about what information will be returned.
}
\examples{
\dontrun{
# with service account token
t <- token_fetch(
  scopes = "https://www.googleapis.com/auth/drive",
  path   = "path/to/service/account/token/blah-blah-blah.json"
)
# or with an OAuth token
t <- token_fetch(
  scopes = "https://www.googleapis.com/auth/drive",
  email  = "janedoe@example.com"
)
token_userinfo(t)
token_email(t)
tokens_tokeninfo(t)
}
}
