% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_seed.R
\name{random_seed}
\alias{random_seed}
\alias{get_random_seed}
\alias{set_random_seed}
\alias{restore_random_seed}
\title{Get, set and restore the state of the random number generator state.}
\usage{
get_random_seed()

set_random_seed(seed)

restore_random_seed(seed)
}
\arguments{
\item{seed}{(\code{list()}|\code{integer(1)})\cr Either an integer or the list returned gy \code{\link[=get_random_seed]{get_random_seed()}}.}
}
\value{
\code{\link[=get_random_seed]{get_random_seed()}} returns a list with two components \code{random_seed} and \code{rng_kind} or NULL if no seed was set; \code{\link[=set_random_seed]{set_random_seed()}} and \code{\link[=restore_random_seed]{restore_random_seed()}} do not return anything.
}
\description{
Get, set and restore the state of the random number generator state.
}
\details{
These functions originate from the \code{\link[withr:with_seed]{withr}} package.
}
\examples{
old_seed <- get_random_seed()
on.exit(restore_random_seed(old_seed))
set_random_seed(42)
value1 <- runif(1)
set_random_seed(42)
value2 <- runif(1)
stopifnot(all.equal(value1,value2))

}
