% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/futuremice.R
\name{futuremice}
\alias{futuremice}
\title{Wrapper function that runs MICE in parallel}
\usage{
futuremice(
  data,
  m = 5,
  parallelseed = NA,
  n.core = NULL,
  seed = NA,
  use.logical = TRUE,
  future.plan = "multisession",
  packages = NULL,
  globals = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame or matrix containing the incomplete data. Similar to
the first argument of \code{\link{mice}}.}

\item{m}{The number of desired imputated datasets. By default $m=5$ as with
\code{mice}}

\item{parallelseed}{A scalar to be used to obtain reproducible results over
the futures. The default \code{parallelseed = NA} will result in a seed value
that is randomly drawn between -999999999 and 999999999.}

\item{n.core}{A scalar indicating the number of cores that should be used.}

\item{seed}{A scalar to be used as the seed value for the mice algorithm
within each parallel stream. Please note that the imputations will be the
same for all streams and, hence, this should be used if and only if
\code{n.core = 1} and if it is desired to obtain the same output as under
\code{mice}.}

\item{use.logical}{A logical indicating whether logical (\code{TRUE}) or
physical (\code{FALSE}) CPU's on machine should be used.}

\item{future.plan}{A character indicating how \code{future}s are resolved.
The default \code{multisession} resolves futures asynchronously (in parallel)
in separate \code{R} sessions running in the background. See
\code{\link[future]{plan}} for more information on future plans.}

\item{packages}{A character vector with additional packages to be used in 
\code{mice} (e.g., for using external imputation functions).}

\item{globals}{A character string with additional functions to be exported to
each future (e.g., user-written imputation functions).}

\item{...}{Named arguments that are passed down to function \code{\link{mice}}.}
}
\value{
A mids object as defined by \code{\link{mids-class}}
}
\description{
This is a wrapper function for \code{\link{mice}}, using multiple cores to
execute \code{\link{mice}} in parallel. As a result, the imputation
procedure can be sped up, which may be useful in general. By default,
\code{\link{futuremice}} distributes the number of imputations \code{m}
about equally over the cores.
}
\details{
This function relies on package \code{\link[furrr]{furrr}}, which is a
package for R versions 3.2.0 and later. We have chosen to use furrr function
\code{future_map} to allow the use of \code{futuremice} on Mac, Linux and
Windows systems.


This wrapper function combines the output of \code{\link[furrr]{future_map}} with
function \code{\link{ibind}} from the \code{\link{mice}} package. A
\code{mids} object is returned and can be used for further analyses.

A seed value can be specified in the global environment, which will yield
reproducible results. A seed value can also be specified within the
\code{\link{futuremice}} call, through specifying the argument
\code{parallelseed}. If \code{parallelseed} is not specified, a seed value is
drawn randomly by default, and accessible through \code{$parallelseed} in the
output object. Hence, results will always be reproducible, regardless of
whether the seed is specified in the global environment, or by setting the
same seed within the function (potentially by extracting the seed from the
\code{futuremice} output object.
}
\examples{
# 150 imputations in dataset nhanes, performed by 3 cores
\dontrun{
imp1 <- futuremice(data = nhanes, m = 150, n.core = 3)
# Making use of arguments in mice.
imp2 <- futuremice(data = nhanes, m = 100, method = "norm.nob")
imp2$method
fit <- with(imp2, lm(bmi ~ hyp))
pool(fit)
}

}
\references{
Volker, T.B. and Vink, G. (2022). futuremice: The future starts today.
\url{https://www.gerkovink.com/miceVignettes/futuremice/Vignette_futuremice.html}

#'Van Buuren, S. (2018).
\href{https://stefvanbuuren.name/fimd/parallel-computation.html}{\emph{Flexible Imputation of Missing Data. Second Edition.}}
Chapman & Hall/CRC. Boca Raton, FL.
}
\seealso{
\code{\link[future]{future}}, \code{\link[furrr]{furrr}}, \code{\link[furrr]{future_map}},
\code{\link[future]{plan}}, \code{\link{mice}}, \code{\link{mids-class}}
}
\author{
Thom Benjamin Volker, Gerko Vink
}
