% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimreduc.R
\name{DimReduc-validity}
\alias{DimReduc-validity}
\title{Dimensional Reduction Validity}
\description{
Validation of \code{DimReduc} objects is handled by
\code{\link[methods]{validObject}}
}
\section{Cell Embeddings Validation}{

The cell embeddings matrix must be a numeric matrix of dimensions
\eqn{n_{cells}} by \eqn{d_{dimensions}}; row names must be the cell names
and column names must be the dimension identifier. The dimension identifier
must be \dQuote{\code{key_dimension}} (eg. \dQuote{\code{PC_1}}). Dimension
identifiers must be in order and cannot be skipped
}

\section{Feature and Projected Feature Loadings Validation}{

blah
}

\section{Standard Deviations Validation}{

blah
}

\section{Key Validation}{

Keys must be a one-length character vector; a key must be composed of one
of the following:
\itemize{
 \item An empty string (eg. \dQuote{\code{''}}) where \code{nzchar() == 0}
 \item An string composed of one or more alphanumeric values
 (both lower- and upper-case) that ends with an underscore
 (\dQuote{\code{_}}); the first character must be a letter
}
Keys that are not empty strings are validated with the regex
\dQuote{\code{\Sexpr[stage=build]{SeuratObject:::.KeyPattern()}}}
}

\seealso{
Dimensional reduction object, validity, and interaction methods
\code{\link{CreateDimReducObject}()},
\code{\link{DimReduc-class}},
\code{\link{[.DimReduc}()},
\code{\link{[[.DimReduc}()},
\code{\link{dim.DimReduc}()},
\code{\link{merge.DimReduc}()},
\code{\link{print.DimReduc}()},
\code{\link{subset.DimReduc}()}
}
\concept{dimreduc}
