% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stub_body_diff.R
\name{stub_body_diff}
\alias{stub_body_diff}
\title{Get a diff of a stub request body and a request body from an http request}
\usage{
stub_body_diff(stub = last_stub(), request = last_request())
}
\arguments{
\item{stub}{object of class \code{StubbedRequest}. required. default is to
call \code{\link[=last_stub]{last_stub()}}, which gets the last stub created}

\item{request}{object of class \code{RequestSignature}. required. default is to
call \code{\link[=last_request]{last_request()}}, which gets the last stub created}
}
\value{
object of class \code{Diff} from the \pkg{diffobj} package
}
\description{
Requires the Suggested package \code{diffobj}
}
\details{
Returns error message if either \code{stub} or \code{request} are \code{NULL}.
Even though you may not intentionally pass in a \code{NULL}, the return values
of \code{\link[=last_stub]{last_stub()}} and \code{\link[=last_request]{last_request()}} when there's nothing found is \code{NULL}.

Under the hood the Suggested package \code{diffobj} is used to do the comparison.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# stops with error if no stub and request
request_registry_clear()
stub_registry_clear()
stub_body_diff()

# Gives diff when there's a stub and request found - however, no request body
stub_request("get", "https://hb.opencpu.org/get")
enable()
library(crul)
HttpClient$new("https://hb.opencpu.org")$get(path = "get")
stub_body_diff()

# Gives diff when there's a stub and request found - with request body
stub_request("post", "https://hb.opencpu.org/post") \%>\%
  wi_th(body = list(apple = "green"))
enable()
library(crul)
HttpClient$new("https://hb.opencpu.org")$post(
  path = "post", body = list(apple = "red")
)
stub_body_diff()

# Gives diff when there's a stub and request found - with request body
stub_request("post", "https://hb.opencpu.org/post") \%>\%
  wi_th(body = "the quick brown fox")
HttpClient$new("https://hb.opencpu.org")$post(
  path = "post", body = "the quick black fox"
)
stub_body_diff()
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=webmockr_configure]{webmockr_configure()}} to toggle \code{webmockr} showing request body
diffs when there's not a match. \code{stub_body_diff()} is offered as a manual
way to compare requests and stubs - whereas turning on with
\code{\link[=webmockr_configure]{webmockr_configure()}} will do the diff for you.
}
