# Announce: Rakudo compiler, Release #140 (2020.10)

On behalf of the Rakudo development team, I’m very happy to announce the
October 2020 release of Rakudo #140. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2020.10:

  + Additions:
    + Implement `MAIN` parameter bundling via the `%*SUB-MAIN-OPTS<bundling>`
      option [75f92d2b][04164a0f]
    + Generate a `rakuw.exe` executable on Windows which will not spawn
      a console window (in contrast to the `raku.exe` executable) [0ea6902d][708d0ca6]
    + Add 𝐑𝐚𝐤𝐮𝐝𝐨™ and 𝐑𝐚𝐤𝐮™ welcome message [80a4ada6][4e9178f8][bae905ef]
  + Changes:
    + Add a new implementation for multi-level Hash slicing,
      not backward-compatible with `6.c` version and to be enabled since `6.e`
       [551b577d][f106c231][6986ea1d][8a2d9a61][1c08e66b][1c08e66b]
       [d08247db][94d89686][18f3808e][4b278bcb][f9b3f925][b1ec2489]
       [d6e94aed][564faa64][93503c24][b60772fa][198f6030][ff2f2b0c]
       [420cb1f4][c701a482][1971ba46][964f6e48][3ca1fede][54eb4314]
       [d713e451]
    + `False.truncate` returns `False` instead of 0 now [7192a99e]
    + Make "is rw" on parameters of MAIN worry [d0854ffc]
    + Change `IterationBuffer.raku` output.
      Note that IterationBuffer.raku is a debugging tool: it does
      *not* roundtrip, nor is it the intent that it ever will. [33bb6504]
  + Efficiency:
    + Adapt to simplified `nqp::isprime_I` [80bf1db1]
    + Make `%a{a;b}` about 30% faster [a5774094]
    + Further simplify `%h{a;b;c}` candidate [e435a087]
    + Make `Hash.DELETE-KEY` on a non-existing key 40% faster
      [3131ce25][fcabad44]
    + Make making a `Uni` between 1.5x and 22x as fast [2999be32]
    + Make `.grep/.first` on native arrays about 3.5x as fast
      [240bc9eb][cf239477]
    + Make `.unique/.repeated/.squish` on native arrays faster [c37ffe71]
  + Fixes:
    + Fix stub packages in multi part declarations only knowing
      part of their name [51db5341]
    + Build System: Add a check to prevent building a Rakudo with a
      stale NQP version [4dbdcb8d][d8db03b5]
    + Make BUILD(ALL)PLAN output a bit clearer [a26beb66]
    + Make `$*USER` and `$*GROUP` return correct values on some non-English
      locales [6a89d716]
    + Fix possible race in multi-threaded precompilation [12946210]
    + Produce a better error message for `my &MAIN = { }` [e0e24a8d]
    + Fix issue with Z / X used with set operators [338c7439]
    + Produce a better error message for incorrect code `infix:(&)` [4af961ed]
    + Fix NativeCall/C++ to allow double instantiation [ecaf334c][f3ffb702]
    + An attempt to copy a directory to a file does not remove the file
      anymore [41a76cad]
    + Fix a problem with multi submethods been treated as method [7cfca098]
  + Internal:
    + More fixes to the binary release scripts [bd029ae4][99acfa9c]
    + Move `Int` candidates from Numeric.pm6 to Int.pm6 [bf799bae]
    + Add `.gitattributes` file and specify file extensions [42e0434d]


The following people contributed to this release:

Elizabeth Mattijsen, Patrick Böker, Will "Coke" Coleda, Daniel Green,
Stoned Elipot, Alexander Kiryuhin, Nicholas Clark, Vadim Belman,
Christian Bartolomäus, Stefan Seifert, Zoffix Znet, Moritz Lenz,
Norbert Buchmueller, Alexandre Jousset, Jakub A. G, José Joaquín Atria,
Tom Browder, Aleks-Daniel Jakimenko-Aleksejev, Clifton Wood,
Daniel Mita, JJ Merelo, Leon Timmermans, Perry Thompson, Simon Proctor,
stoned, wayland

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2020 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#141), is tentatively scheduled for 2020-11-21.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
