// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2023 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from SensorLogger.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.sensors {
  public class Logger_3_0_1 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("sensors.Logger:3.0.1", null);

    public Logger_3_0_1(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Logger_3_0_1(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Logger_3_0_1 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Logger_3_0_1(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public class Info : ICloneable {
      public object Clone() {
        Info copy = new Info();
        copy.samplePeriod = this.samplePeriod;
        copy.maxTotalRecords = this.maxTotalRecords;
        copy.effectiveCapacity = this.effectiveCapacity;
        copy.oldestRecId = this.oldestRecId;
        copy.newestRecId = this.newestRecId;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["samplePeriod"] = this.samplePeriod;
        json["maxTotalRecords"] = this.maxTotalRecords;
        json["effectiveCapacity"] = this.effectiveCapacity;
        json["oldestRecId"] = this.oldestRecId;
        json["newestRecId"] = this.newestRecId;
        return json;
      }

      public static Info Decode(LightJson.JsonObject json, Agent agent) {
        Info inst = new Info();
        inst.samplePeriod = (int)json["samplePeriod"];
        inst.maxTotalRecords = (int)json["maxTotalRecords"];
        inst.effectiveCapacity = (int)json["effectiveCapacity"];
        inst.oldestRecId = (int)json["oldestRecId"];
        inst.newestRecId = (int)json["newestRecId"];
        return inst;
      }

      public int samplePeriod = 0;
      public int maxTotalRecords = 0;
      public int effectiveCapacity = 0;
      public int oldestRecId = 0;
      public int newestRecId = 0;
    }

    public class Settings : ICloneable {
      public object Clone() {
        Settings copy = new Settings();
        copy.isEnabled = this.isEnabled;
        copy.samplesPerRecord = this.samplesPerRecord;
        copy.logCapacity = this.logCapacity;
        copy.backupEnabled = this.backupEnabled;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["isEnabled"] = this.isEnabled;
        json["samplesPerRecord"] = this.samplesPerRecord;
        json["logCapacity"] = this.logCapacity;
        json["backupEnabled"] = this.backupEnabled;
        return json;
      }

      public static Settings Decode(LightJson.JsonObject json, Agent agent) {
        Settings inst = new Settings();
        inst.isEnabled = (bool)json["isEnabled"];
        inst.samplesPerRecord = (int)json["samplesPerRecord"];
        inst.logCapacity = (int)json["logCapacity"];
        inst.backupEnabled = (bool)json["backupEnabled"];
        return inst;
      }

      public bool isEnabled = false;
      public int samplesPerRecord = 0;
      public int logCapacity = 0;
      public bool backupEnabled = false;
    }

    public class SensorSet : ICloneable {
      public object Clone() {
        SensorSet copy = new SensorSet();
        copy.sensors = this.sensors;
        copy.slots = this.slots;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["sensors"] = new JsonArray(this.sensors.Select(
          _value => (JsonValue)(_value != null ? _value.Encode() : JsonValue.Null)));
        json["slots"] = new JsonArray(this.slots.Select(
          _value => (JsonValue)(_value != null ? _value.Encode() : JsonValue.Null)));
        return json;
      }

      public static SensorSet Decode(LightJson.JsonObject json, Agent agent) {
        SensorSet inst = new SensorSet();
        inst.sensors = new System.Collections.Generic.List<Com.Raritan.Idl.sensors.Sensor_4_0_5>(json["sensors"].AsJsonArray.Select(
          _value => Com.Raritan.Idl.sensors.Sensor_4_0_5.StaticCast(ObjectProxy.Decode(_value, agent))));
        inst.slots = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.DeviceSlot_4_0_2>(json["slots"].AsJsonArray.Select(
          _value => Com.Raritan.Idl.peripheral.DeviceSlot_4_0_2.StaticCast(ObjectProxy.Decode(_value, agent))));
        return inst;
      }

      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.sensors.Sensor_4_0_5> sensors = new System.Collections.Generic.List<Com.Raritan.Idl.sensors.Sensor_4_0_5>();
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.DeviceSlot_4_0_2> slots = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.DeviceSlot_4_0_2>();
    }

    public class InfoChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("sensors.Logger_3_0_1.InfoChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public Com.Raritan.Idl.sensors.Logger_3_0_1.Info oldInfo = new Com.Raritan.Idl.sensors.Logger_3_0_1.Info();
      public Com.Raritan.Idl.sensors.Logger_3_0_1.Info newInfo = new Com.Raritan.Idl.sensors.Logger_3_0_1.Info();
    }

    public class SettingsChangedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("sensors.Logger_3_0_1.SettingsChangedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public Com.Raritan.Idl.sensors.Logger_3_0_1.Settings oldSettings = new Com.Raritan.Idl.sensors.Logger_3_0_1.Settings();
      public Com.Raritan.Idl.sensors.Logger_3_0_1.Settings newSettings = new Com.Raritan.Idl.sensors.Logger_3_0_1.Settings();
    }

    public class LoggedSensorsChangedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("sensors.Logger_3_0_1.LoggedSensorsChangedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public Com.Raritan.Idl.sensors.Logger_3_0_1.SensorSet oldSensors = new Com.Raritan.Idl.sensors.Logger_3_0_1.SensorSet();
      public Com.Raritan.Idl.sensors.Logger_3_0_1.SensorSet newSensors = new Com.Raritan.Idl.sensors.Logger_3_0_1.SensorSet();
    }

    public class GetInfoResult {
      public Com.Raritan.Idl.sensors.Logger_3_0_1.Info _ret_;
    }

    public GetInfoResult getInfo() {
      JsonObject _parameters = null;
      var _result = RpcCall("getInfo", _parameters);
      var _ret = new GetInfoResult();
      _ret._ret_ = Com.Raritan.Idl.sensors.Logger_3_0_1.Info.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getInfo(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getInfo", _parameters,
        _result => {
          try {
            var _ret = new GetInfoResult();
            _ret._ret_ = Com.Raritan.Idl.sensors.Logger_3_0_1.Info.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSettingsResult {
      public Com.Raritan.Idl.sensors.Logger_3_0_1.Settings _ret_;
    }

    public GetSettingsResult getSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSettings", _parameters);
      var _ret = new GetSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.sensors.Logger_3_0_1.Settings.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSettings", _parameters,
        _result => {
          try {
            var _ret = new GetSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.sensors.Logger_3_0_1.Settings.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetSettingsResult {
      public int _ret_;
    }

    public SetSettingsResult setSettings(Com.Raritan.Idl.sensors.Logger_3_0_1.Settings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setSettings", _parameters);
      var _ret = new SetSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.sensors.Logger_3_0_1.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setSettings(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.sensors.Logger_3_0_1.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setSettings", _parameters,
        _result => {
          try {
            var _ret = new SetSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public const int STATE_UNAVAILABLE = 0;

    public const int STATE_OPEN = 1;

    public const int STATE_CLOSE = 2;

    public const int STATE_BELOW_LOWER_CRITICAL = 3;

    public const int STATE_BELOW_LOWER_WARNING = 4;

    public const int STATE_NORMAL = 5;

    public const int STATE_ABOVE_UPPER_WARNING = 6;

    public const int STATE_ABOVE_UPPER_CRITICAL = 7;

    public const int STATE_ON = 8;

    public const int STATE_OFF = 9;

    public const int STATE_ALARMED = 10;

    public const int STATE_OK = 11;

    public const int STATE_MARGINAL = 12;

    public const int STATE_FAIL = 13;

    public const int STATE_YES = 14;

    public const int STATE_NO = 15;

    public const int STATE_STANDBY = 16;

    public const int STATE_ONE = 17;

    public const int STATE_TWO = 18;

    public const int STATE_IN_SYNC = 19;

    public const int STATE_OUT_OF_SYNC = 20;

    public const int STATE_FAULT = 21;

    public const int STATE_SELF_TEST = 22;

    public const int STATE_I1_OPEN_FAULT = 23;

    public const int STATE_I1_SHORT_FAULT = 24;

    public const int STATE_I2_OPEN_FAULT = 25;

    public const int STATE_I2_SHORT_FAULT = 26;

    public const int STATE_WARNING = 27;

    public const int STATE_CRITICAL = 28;

    public const int STATE_NON_REDUNDANT = 29;

    public class GetTimeStampsResult {
      public int _ret_;
      public System.Collections.Generic.IEnumerable<System.DateTime> timestamps;
    }

    public GetTimeStampsResult getTimeStamps(int recid, int count) {
      var _parameters = new LightJson.JsonObject();
      _parameters["recid"] = recid;
      _parameters["count"] = count;

      var _result = RpcCall("getTimeStamps", _parameters);
      var _ret = new GetTimeStampsResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.timestamps = new System.Collections.Generic.List<System.DateTime>(_result["timestamps"].AsJsonArray.Select(
        _value => new System.DateTime(_value * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime()));
      return _ret;
    }

    public AsyncRequest getTimeStamps(int recid, int count, AsyncRpcResponse<GetTimeStampsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getTimeStamps(recid, count, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getTimeStamps(int recid, int count, AsyncRpcResponse<GetTimeStampsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["recid"] = recid;
        _parameters["count"] = count;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getTimeStamps", _parameters,
        _result => {
          try {
            var _ret = new GetTimeStampsResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.timestamps = new System.Collections.Generic.List<System.DateTime>(_result["timestamps"].AsJsonArray.Select(
              _value => new System.DateTime(_value * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime()));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class Record : ICloneable {
      public object Clone() {
        Record copy = new Record();
        copy.available = this.available;
        copy.takenValidSamples = this.takenValidSamples;
        copy.state = this.state;
        copy.minValue = this.minValue;
        copy.avgValue = this.avgValue;
        copy.maxValue = this.maxValue;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["available"] = this.available;
        json["takenValidSamples"] = this.takenValidSamples;
        json["state"] = this.state;
        json["minValue"] = this.minValue;
        json["avgValue"] = this.avgValue;
        json["maxValue"] = this.maxValue;
        return json;
      }

      public static Record Decode(LightJson.JsonObject json, Agent agent) {
        Record inst = new Record();
        inst.available = (bool)json["available"];
        inst.takenValidSamples = (int)json["takenValidSamples"];
        inst.state = (int)json["state"];
        inst.minValue = (double)json["minValue"];
        inst.avgValue = (double)json["avgValue"];
        inst.maxValue = (double)json["maxValue"];
        return inst;
      }

      public bool available = false;
      public int takenValidSamples = 0;
      public int state = 0;
      public double minValue = 0.0;
      public double avgValue = 0.0;
      public double maxValue = 0.0;
    }

    public class GetSensorRecordsResult {
      public int _ret_;
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.sensors.Logger_3_0_1.Record> recs;
    }

    public GetSensorRecordsResult getSensorRecords(Com.Raritan.Idl.sensors.Sensor_4_0_5 sensor, int recid, int count) {
      var _parameters = new LightJson.JsonObject();
      _parameters["sensor"] = sensor != null ? sensor.Encode() : JsonValue.Null;
      _parameters["recid"] = recid;
      _parameters["count"] = count;

      var _result = RpcCall("getSensorRecords", _parameters);
      var _ret = new GetSensorRecordsResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.recs = new System.Collections.Generic.List<Com.Raritan.Idl.sensors.Logger_3_0_1.Record>(_result["recs"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.sensors.Logger_3_0_1.Record.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getSensorRecords(Com.Raritan.Idl.sensors.Sensor_4_0_5 sensor, int recid, int count, AsyncRpcResponse<GetSensorRecordsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSensorRecords(sensor, recid, count, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSensorRecords(Com.Raritan.Idl.sensors.Sensor_4_0_5 sensor, int recid, int count, AsyncRpcResponse<GetSensorRecordsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["sensor"] = sensor != null ? sensor.Encode() : JsonValue.Null;
        _parameters["recid"] = recid;
        _parameters["count"] = count;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getSensorRecords", _parameters,
        _result => {
          try {
            var _ret = new GetSensorRecordsResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.recs = new System.Collections.Generic.List<Com.Raritan.Idl.sensors.Logger_3_0_1.Record>(_result["recs"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.sensors.Logger_3_0_1.Record.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetPeripheralDeviceRecordsResult {
      public int _ret_;
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.sensors.Logger_3_0_1.Record> recs;
    }

    public GetPeripheralDeviceRecordsResult getPeripheralDeviceRecords(Com.Raritan.Idl.peripheral.DeviceSlot_4_0_2 slot, int recid, int count) {
      var _parameters = new LightJson.JsonObject();
      _parameters["slot"] = slot != null ? slot.Encode() : JsonValue.Null;
      _parameters["recid"] = recid;
      _parameters["count"] = count;

      var _result = RpcCall("getPeripheralDeviceRecords", _parameters);
      var _ret = new GetPeripheralDeviceRecordsResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.recs = new System.Collections.Generic.List<Com.Raritan.Idl.sensors.Logger_3_0_1.Record>(_result["recs"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.sensors.Logger_3_0_1.Record.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getPeripheralDeviceRecords(Com.Raritan.Idl.peripheral.DeviceSlot_4_0_2 slot, int recid, int count, AsyncRpcResponse<GetPeripheralDeviceRecordsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getPeripheralDeviceRecords(slot, recid, count, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getPeripheralDeviceRecords(Com.Raritan.Idl.peripheral.DeviceSlot_4_0_2 slot, int recid, int count, AsyncRpcResponse<GetPeripheralDeviceRecordsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["slot"] = slot != null ? slot.Encode() : JsonValue.Null;
        _parameters["recid"] = recid;
        _parameters["count"] = count;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getPeripheralDeviceRecords", _parameters,
        _result => {
          try {
            var _ret = new GetPeripheralDeviceRecordsResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.recs = new System.Collections.Generic.List<Com.Raritan.Idl.sensors.Logger_3_0_1.Record>(_result["recs"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.sensors.Logger_3_0_1.Record.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class TimedRecord : ICloneable {
      public object Clone() {
        TimedRecord copy = new TimedRecord();
        copy.timestamp = this.timestamp;
        copy.record = this.record;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["timestamp"] = (this.timestamp.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
        json["record"] = this.record.Encode();
        return json;
      }

      public static TimedRecord Decode(LightJson.JsonObject json, Agent agent) {
        TimedRecord inst = new TimedRecord();
        inst.timestamp = new System.DateTime(json["timestamp"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
        inst.record = Com.Raritan.Idl.sensors.Logger_3_0_1.Record.Decode(json["record"], agent);
        return inst;
      }

      public System.DateTime timestamp = new System.DateTime(0);
      public Com.Raritan.Idl.sensors.Logger_3_0_1.Record record = new Com.Raritan.Idl.sensors.Logger_3_0_1.Record();
    }

    public class GetSensorTimedRecordsResult {
      public int _ret_;
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.sensors.Logger_3_0_1.TimedRecord> recs;
    }

    public GetSensorTimedRecordsResult getSensorTimedRecords(Com.Raritan.Idl.sensors.Sensor_4_0_5 sensor, int recid, int count) {
      var _parameters = new LightJson.JsonObject();
      _parameters["sensor"] = sensor != null ? sensor.Encode() : JsonValue.Null;
      _parameters["recid"] = recid;
      _parameters["count"] = count;

      var _result = RpcCall("getSensorTimedRecords", _parameters);
      var _ret = new GetSensorTimedRecordsResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.recs = new System.Collections.Generic.List<Com.Raritan.Idl.sensors.Logger_3_0_1.TimedRecord>(_result["recs"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.sensors.Logger_3_0_1.TimedRecord.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getSensorTimedRecords(Com.Raritan.Idl.sensors.Sensor_4_0_5 sensor, int recid, int count, AsyncRpcResponse<GetSensorTimedRecordsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSensorTimedRecords(sensor, recid, count, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSensorTimedRecords(Com.Raritan.Idl.sensors.Sensor_4_0_5 sensor, int recid, int count, AsyncRpcResponse<GetSensorTimedRecordsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["sensor"] = sensor != null ? sensor.Encode() : JsonValue.Null;
        _parameters["recid"] = recid;
        _parameters["count"] = count;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getSensorTimedRecords", _parameters,
        _result => {
          try {
            var _ret = new GetSensorTimedRecordsResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.recs = new System.Collections.Generic.List<Com.Raritan.Idl.sensors.Logger_3_0_1.TimedRecord>(_result["recs"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.sensors.Logger_3_0_1.TimedRecord.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetPeripheralDeviceTimedRecordsResult {
      public int _ret_;
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.sensors.Logger_3_0_1.TimedRecord> recs;
    }

    public GetPeripheralDeviceTimedRecordsResult getPeripheralDeviceTimedRecords(Com.Raritan.Idl.peripheral.DeviceSlot_4_0_2 slot, int recid, int count) {
      var _parameters = new LightJson.JsonObject();
      _parameters["slot"] = slot != null ? slot.Encode() : JsonValue.Null;
      _parameters["recid"] = recid;
      _parameters["count"] = count;

      var _result = RpcCall("getPeripheralDeviceTimedRecords", _parameters);
      var _ret = new GetPeripheralDeviceTimedRecordsResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.recs = new System.Collections.Generic.List<Com.Raritan.Idl.sensors.Logger_3_0_1.TimedRecord>(_result["recs"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.sensors.Logger_3_0_1.TimedRecord.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getPeripheralDeviceTimedRecords(Com.Raritan.Idl.peripheral.DeviceSlot_4_0_2 slot, int recid, int count, AsyncRpcResponse<GetPeripheralDeviceTimedRecordsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getPeripheralDeviceTimedRecords(slot, recid, count, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getPeripheralDeviceTimedRecords(Com.Raritan.Idl.peripheral.DeviceSlot_4_0_2 slot, int recid, int count, AsyncRpcResponse<GetPeripheralDeviceTimedRecordsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["slot"] = slot != null ? slot.Encode() : JsonValue.Null;
        _parameters["recid"] = recid;
        _parameters["count"] = count;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getPeripheralDeviceTimedRecords", _parameters,
        _result => {
          try {
            var _ret = new GetPeripheralDeviceTimedRecordsResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.recs = new System.Collections.Generic.List<Com.Raritan.Idl.sensors.Logger_3_0_1.TimedRecord>(_result["recs"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.sensors.Logger_3_0_1.TimedRecord.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetLoggedSensorsResult {
      public Com.Raritan.Idl.sensors.Logger_3_0_1.SensorSet _ret_;
    }

    public GetLoggedSensorsResult getLoggedSensors() {
      JsonObject _parameters = null;
      var _result = RpcCall("getLoggedSensors", _parameters);
      var _ret = new GetLoggedSensorsResult();
      _ret._ret_ = Com.Raritan.Idl.sensors.Logger_3_0_1.SensorSet.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getLoggedSensors(AsyncRpcResponse<GetLoggedSensorsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getLoggedSensors(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getLoggedSensors(AsyncRpcResponse<GetLoggedSensorsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getLoggedSensors", _parameters,
        _result => {
          try {
            var _ret = new GetLoggedSensorsResult();
            _ret._ret_ = Com.Raritan.Idl.sensors.Logger_3_0_1.SensorSet.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetLoggedSensorsResult {
      public int _ret_;
    }

    public SetLoggedSensorsResult setLoggedSensors(Com.Raritan.Idl.sensors.Logger_3_0_1.SensorSet sensors) {
      var _parameters = new LightJson.JsonObject();
      _parameters["sensors"] = sensors.Encode();

      var _result = RpcCall("setLoggedSensors", _parameters);
      var _ret = new SetLoggedSensorsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setLoggedSensors(Com.Raritan.Idl.sensors.Logger_3_0_1.SensorSet sensors, AsyncRpcResponse<SetLoggedSensorsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setLoggedSensors(sensors, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setLoggedSensors(Com.Raritan.Idl.sensors.Logger_3_0_1.SensorSet sensors, AsyncRpcResponse<SetLoggedSensorsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["sensors"] = sensors.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setLoggedSensors", _parameters,
        _result => {
          try {
            var _ret = new SetLoggedSensorsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class EnableSensorsResult {
      public int _ret_;
    }

    public EnableSensorsResult enableSensors(Com.Raritan.Idl.sensors.Logger_3_0_1.SensorSet sensors) {
      var _parameters = new LightJson.JsonObject();
      _parameters["sensors"] = sensors.Encode();

      var _result = RpcCall("enableSensors", _parameters);
      var _ret = new EnableSensorsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest enableSensors(Com.Raritan.Idl.sensors.Logger_3_0_1.SensorSet sensors, AsyncRpcResponse<EnableSensorsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return enableSensors(sensors, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest enableSensors(Com.Raritan.Idl.sensors.Logger_3_0_1.SensorSet sensors, AsyncRpcResponse<EnableSensorsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["sensors"] = sensors.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("enableSensors", _parameters,
        _result => {
          try {
            var _ret = new EnableSensorsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class DisableSensorsResult {
      public int _ret_;
    }

    public DisableSensorsResult disableSensors(Com.Raritan.Idl.sensors.Logger_3_0_1.SensorSet sensors) {
      var _parameters = new LightJson.JsonObject();
      _parameters["sensors"] = sensors.Encode();

      var _result = RpcCall("disableSensors", _parameters);
      var _ret = new DisableSensorsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest disableSensors(Com.Raritan.Idl.sensors.Logger_3_0_1.SensorSet sensors, AsyncRpcResponse<DisableSensorsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return disableSensors(sensors, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest disableSensors(Com.Raritan.Idl.sensors.Logger_3_0_1.SensorSet sensors, AsyncRpcResponse<DisableSensorsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["sensors"] = sensors.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("disableSensors", _parameters,
        _result => {
          try {
            var _ret = new DisableSensorsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class IsSensorEnabledResult {
      public bool _ret_;
    }

    public IsSensorEnabledResult isSensorEnabled(Com.Raritan.Idl.sensors.Sensor_4_0_5 sensor) {
      var _parameters = new LightJson.JsonObject();
      _parameters["sensor"] = sensor != null ? sensor.Encode() : JsonValue.Null;

      var _result = RpcCall("isSensorEnabled", _parameters);
      var _ret = new IsSensorEnabledResult();
      _ret._ret_ = (bool)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest isSensorEnabled(Com.Raritan.Idl.sensors.Sensor_4_0_5 sensor, AsyncRpcResponse<IsSensorEnabledResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return isSensorEnabled(sensor, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest isSensorEnabled(Com.Raritan.Idl.sensors.Sensor_4_0_5 sensor, AsyncRpcResponse<IsSensorEnabledResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["sensor"] = sensor != null ? sensor.Encode() : JsonValue.Null;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("isSensorEnabled", _parameters,
        _result => {
          try {
            var _ret = new IsSensorEnabledResult();
            _ret._ret_ = (bool)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class IsSlotEnabledResult {
      public bool _ret_;
    }

    public IsSlotEnabledResult isSlotEnabled(Com.Raritan.Idl.peripheral.DeviceSlot_4_0_2 slot) {
      var _parameters = new LightJson.JsonObject();
      _parameters["slot"] = slot != null ? slot.Encode() : JsonValue.Null;

      var _result = RpcCall("isSlotEnabled", _parameters);
      var _ret = new IsSlotEnabledResult();
      _ret._ret_ = (bool)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest isSlotEnabled(Com.Raritan.Idl.peripheral.DeviceSlot_4_0_2 slot, AsyncRpcResponse<IsSlotEnabledResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return isSlotEnabled(slot, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest isSlotEnabled(Com.Raritan.Idl.peripheral.DeviceSlot_4_0_2 slot, AsyncRpcResponse<IsSlotEnabledResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["slot"] = slot != null ? slot.Encode() : JsonValue.Null;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("isSlotEnabled", _parameters,
        _result => {
          try {
            var _ret = new IsSlotEnabledResult();
            _ret._ret_ = (bool)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class EnableAllSensorsResult {
    }

    public EnableAllSensorsResult enableAllSensors() {
      JsonObject _parameters = null;
      var _result = RpcCall("enableAllSensors", _parameters);
      var _ret = new EnableAllSensorsResult();
      return _ret;
    }

    public AsyncRequest enableAllSensors(AsyncRpcResponse<EnableAllSensorsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return enableAllSensors(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest enableAllSensors(AsyncRpcResponse<EnableAllSensorsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("enableAllSensors", _parameters,
        _result => {
          try {
            var _ret = new EnableAllSensorsResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class DisableAllSensorsResult {
    }

    public DisableAllSensorsResult disableAllSensors() {
      JsonObject _parameters = null;
      var _result = RpcCall("disableAllSensors", _parameters);
      var _ret = new DisableAllSensorsResult();
      return _ret;
    }

    public AsyncRequest disableAllSensors(AsyncRpcResponse<DisableAllSensorsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return disableAllSensors(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest disableAllSensors(AsyncRpcResponse<DisableAllSensorsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("disableAllSensors", _parameters,
        _result => {
          try {
            var _ret = new DisableAllSensorsResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSensorSetTimestampResult {
      public System.DateTime _ret_;
    }

    public GetSensorSetTimestampResult getSensorSetTimestamp() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSensorSetTimestamp", _parameters);
      var _ret = new GetSensorSetTimestampResult();
      _ret._ret_ = new System.DateTime(_result["_ret_"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
      return _ret;
    }

    public AsyncRequest getSensorSetTimestamp(AsyncRpcResponse<GetSensorSetTimestampResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSensorSetTimestamp(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSensorSetTimestamp(AsyncRpcResponse<GetSensorSetTimestampResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSensorSetTimestamp", _parameters,
        _result => {
          try {
            var _ret = new GetSensorSetTimestampResult();
            _ret._ret_ = new System.DateTime(_result["_ret_"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class LogRow : ICloneable {
      public object Clone() {
        LogRow copy = new LogRow();
        copy.sensorSetTimestamp = this.sensorSetTimestamp;
        copy.timestamp = this.timestamp;
        copy.sensorRecords = this.sensorRecords;
        copy.peripheralDeviceRecords = this.peripheralDeviceRecords;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["sensorSetTimestamp"] = (this.sensorSetTimestamp.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
        json["timestamp"] = (this.timestamp.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
        json["sensorRecords"] = new JsonArray(this.sensorRecords.Select(
          _value => (JsonValue)(_value.Encode())));
        json["peripheralDeviceRecords"] = new JsonArray(this.peripheralDeviceRecords.Select(
          _value => (JsonValue)(_value.Encode())));
        return json;
      }

      public static LogRow Decode(LightJson.JsonObject json, Agent agent) {
        LogRow inst = new LogRow();
        inst.sensorSetTimestamp = new System.DateTime(json["sensorSetTimestamp"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
        inst.timestamp = new System.DateTime(json["timestamp"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
        inst.sensorRecords = new System.Collections.Generic.List<Com.Raritan.Idl.sensors.Logger_3_0_1.Record>(json["sensorRecords"].AsJsonArray.Select(
          _value => Com.Raritan.Idl.sensors.Logger_3_0_1.Record.Decode(_value, agent)));
        inst.peripheralDeviceRecords = new System.Collections.Generic.List<Com.Raritan.Idl.sensors.Logger_3_0_1.Record>(json["peripheralDeviceRecords"].AsJsonArray.Select(
          _value => Com.Raritan.Idl.sensors.Logger_3_0_1.Record.Decode(_value, agent)));
        return inst;
      }

      public System.DateTime sensorSetTimestamp = new System.DateTime(0);
      public System.DateTime timestamp = new System.DateTime(0);
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.sensors.Logger_3_0_1.Record> sensorRecords = new System.Collections.Generic.List<Com.Raritan.Idl.sensors.Logger_3_0_1.Record>();
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.sensors.Logger_3_0_1.Record> peripheralDeviceRecords = new System.Collections.Generic.List<Com.Raritan.Idl.sensors.Logger_3_0_1.Record>();
    }

    public class GetLogRowResult {
      public int _ret_;
      public Com.Raritan.Idl.sensors.Logger_3_0_1.LogRow row;
    }

    public GetLogRowResult getLogRow(int recid) {
      var _parameters = new LightJson.JsonObject();
      _parameters["recid"] = recid;

      var _result = RpcCall("getLogRow", _parameters);
      var _ret = new GetLogRowResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.row = Com.Raritan.Idl.sensors.Logger_3_0_1.LogRow.Decode(_result["row"], agent);
      return _ret;
    }

    public AsyncRequest getLogRow(int recid, AsyncRpcResponse<GetLogRowResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getLogRow(recid, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getLogRow(int recid, AsyncRpcResponse<GetLogRowResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["recid"] = recid;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getLogRow", _parameters,
        _result => {
          try {
            var _ret = new GetLogRowResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.row = Com.Raritan.Idl.sensors.Logger_3_0_1.LogRow.Decode(_result["row"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
