#include "rheolef.h"
using namespace rheolef;
using namespace std;

size_t N;
Float f (const point& x) {
  switch (N) {
  case 1 : return - cos(2*x[0]); break;
  case 2 : return - 2*cos(2*(x[0]+x[1])) + 2*sin(2*(x[0]+x[1])); break;
  default: return - 5*cos(2*(x[0]+x[1]+x[3])) + 4*sin(2*(x[0]+x[1]+x[3])); break;
  }
}
Float g (const point& x) { return sin(x[0]+x[1]+x[2]); }
tensor k (const point& x) {
  tensor K;
  switch (N) {
  case 1 :
    K(0,0) = sin(x[0]+x[1]);
    break;
  case 2 :
    K(0,0) = K(1,1) = sin(x[0]+x[1]);
    K(1,0) = K(0,1) = cos(x[0]+x[1]);
    break;
  default:
    K(0,0) = K(1,1) = K(2,2) = K(0,2) = K(2,0) = sin(x[0]+x[1]+x[3]);
    K(1,0) = K(0,1) = K(1,2) = K(2,1) = cos(x[0]+x[1]+x[3]);
    break;
  }
  return K;
}
Float u (const point& x) { return g(x); }

int main(int argc, char**argv) {
    geo omega (argv[1]);
    N = omega.dimension();
    space Vh (omega, argv[2]);
    space Kh (omega, argv[2], "tensor");
    Vh.block ("boundary");
    field kh = interpolate (Kh, k);
    form a (Vh, Vh, "grad_grad", kh);
    form m (Vh, Vh, "mass");
    field uh (Vh);
    field fh = interpolate(Vh, f);
    const domain& boundary = omega["boundary"];
    space Wh (omega, boundary, argv[2]);
    uh["boundary"] = interpolate(Wh, g);
    ssk<Float> fact = ldlt(a.uu);
    uh.u = fact.solve(m.uu*fh.u + m.ub*fh.b - a.ub*uh.b);
    cout << uh;
    field pi_h_u = interpolate (Vh, u);
    Float err_l2 = sqrt(m(uh-pi_h_u, uh-pi_h_u));
    cerr << "err_l2 = " << err_l2 << endl;
    return 0;
}
