// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	httptransport "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// New creates a new provisioning API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

// New creates a new provisioning API client with basic auth credentials.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - user: user for basic authentication header.
// - password: password for basic authentication header.
func NewClientWithBasicAuth(host, basePath, scheme, user, password string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BasicAuth(user, password)
	return &Client{transport: transport, formats: strfmt.Default}
}

// New creates a new provisioning API client with a bearer token for authentication.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - bearerToken: bearer token for Bearer authentication header.
func NewClientWithBearerToken(host, basePath, scheme, bearerToken string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BearerToken(bearerToken)
	return &Client{transport: transport, formats: strfmt.Default}
}

/*
Client for provisioning API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption may be used to customize the behavior of Client methods.
type ClientOption func(*runtime.ClientOperation)

// This client is generated with a few options you might find useful for your swagger spec.
//
// Feel free to add you own set of options.

// WithAccept allows the client to force the Accept header
// to negotiate a specific Producer from the server.
//
// You may use this option to set arbitrary extensions to your MIME media type.
func WithAccept(mime string) ClientOption {
	return func(r *runtime.ClientOperation) {
		r.ProducesMediaTypes = []string{mime}
	}
}

// WithAcceptApplicationJSON sets the Accept header to "application/json".
func WithAcceptApplicationJSON(r *runtime.ClientOperation) {
	r.ProducesMediaTypes = []string{"application/json"}
}

// WithAcceptTextPlain sets the Accept header to "text/plain".
func WithAcceptTextPlain(r *runtime.ClientOperation) {
	r.ProducesMediaTypes = []string{"text/plain"}
}

// ClientService is the interface for Client methods
type ClientService interface {
	GetAPI5BridgeLocation(params *GetAPI5BridgeLocationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetApi5BridgeLocationOK, error)

	GetAPI5Bridges(params *GetAPI5BridgesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetApi5BridgesOK, error)

	GetAPI5Gateway(params *GetAPI5GatewayParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetApi5GatewayOK, error)

	GetAPI5Gateways(params *GetAPI5GatewaysParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetApi5GatewaysOK, error)

	GetAPI5OpenvpnCert(params *GetAPI5OpenvpnCertParams, opts ...ClientOption) (*GetApi5OpenvpnCertOK, error)

	GetAPI5OpenvpnConfig(params *GetAPI5OpenvpnConfigParams, opts ...ClientOption) (*GetApi5OpenvpnConfigOK, error)

	GetAPI5Service(params *GetAPI5ServiceParams, opts ...ClientOption) (*GetApi5ServiceOK, error)

	GetAPIAutoconf(params *GetAPIAutoconfParams, opts ...ClientOption) (*GetAPIAutoconfOK, error)

	GetProviderJSON(params *GetProviderJSONParams, opts ...ClientOption) (*GetProviderJSONOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
GetAPI5BridgeLocation gets bridges

fetch bridges by location
*/
func (a *Client) GetAPI5BridgeLocation(params *GetAPI5BridgeLocationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetApi5BridgeLocationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetAPI5BridgeLocationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAPI5BridgeLocation",
		Method:             "GET",
		PathPattern:        "/api/5/bridge/{location}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetAPI5BridgeLocationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetApi5BridgeLocationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetAPI5BridgeLocation: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetAPI5Bridges gets all bridges

Fetch all bridges. This is an optional API endpoint for compatibility with vpnweb, but do not count on all the providers to have it enabled since it makes it easier to enumerate resources. On the other hand, if the service has "open" VPN endpoints, they can enumerate them here freely. Bridges, however, should be more restricted as a general rule.
*/
func (a *Client) GetAPI5Bridges(params *GetAPI5BridgesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetApi5BridgesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetAPI5BridgesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAPI5Bridges",
		Method:             "GET",
		PathPattern:        "/api/5/bridges",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetAPI5BridgesReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetApi5BridgesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetAPI5Bridges: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetAPI5Gateway gets gateways by location countrycode or random

Get Gateways with param countrycode for nearest, or with param location to get a gateway in specific location, or a random one without params
*/
func (a *Client) GetAPI5Gateway(params *GetAPI5GatewayParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetApi5GatewayOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetAPI5GatewayParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAPI5Gateway",
		Method:             "GET",
		PathPattern:        "/api/5/gateway",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetAPI5GatewayReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetApi5GatewayOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetAPI5Gateway: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetAPI5Gateways gets all gateways

Fetch all gateways. This is an optional API endpoint for compatibility with vpnweb, but do not count on all the providers to have it enabled since it makes it easier to enumerate resources. On the other hand, if the service has "open" VPN endpoints, they can enumerate them here freely. Bridges, however, should be more restricted as a general rule.
*/
func (a *Client) GetAPI5Gateways(params *GetAPI5GatewaysParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetApi5GatewaysOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetAPI5GatewaysParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAPI5Gateways",
		Method:             "GET",
		PathPattern:        "/api/5/gateways",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetAPI5GatewaysReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetApi5GatewaysOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetAPI5Gateways: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetAPI5OpenvpnCert gets openvpn cert

Fetch a new key and cert.
*/
func (a *Client) GetAPI5OpenvpnCert(params *GetAPI5OpenvpnCertParams, opts ...ClientOption) (*GetApi5OpenvpnCertOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetAPI5OpenvpnCertParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAPI5OpenvpnCert",
		Method:             "GET",
		PathPattern:        "/api/5/openvpn/cert",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetAPI5OpenvpnCertReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetApi5OpenvpnCertOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetAPI5OpenvpnCert: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetAPI5OpenvpnConfig fetches open v p n config file

fetch a working config file for OpenVPN service.
*/
func (a *Client) GetAPI5OpenvpnConfig(params *GetAPI5OpenvpnConfigParams, opts ...ClientOption) (*GetApi5OpenvpnConfigOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetAPI5OpenvpnConfigParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAPI5OpenvpnConfig",
		Method:             "GET",
		PathPattern:        "/api/5/openvpn/config",
		ProducesMediaTypes: []string{"text/plain"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetAPI5OpenvpnConfigReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetApi5OpenvpnConfigOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetAPI5OpenvpnConfig: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetAPI5Service gets service info

fetch service information, including location and common tunnel config
*/
func (a *Client) GetAPI5Service(params *GetAPI5ServiceParams, opts ...ClientOption) (*GetApi5ServiceOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetAPI5ServiceParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAPI5Service",
		Method:             "GET",
		PathPattern:        "/api/5/service",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetAPI5ServiceReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetApi5ServiceOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetAPI5Service: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetAPIAutoconf fetches open v p n config file

fetch a working config file for OpenVPN service.
*/
func (a *Client) GetAPIAutoconf(params *GetAPIAutoconfParams, opts ...ClientOption) (*GetAPIAutoconfOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetAPIAutoconfParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAPIAutoconf",
		Method:             "GET",
		PathPattern:        "/api/autoconf",
		ProducesMediaTypes: []string{"text/plain"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetAPIAutoconfReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetAPIAutoconfOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetAPIAutoconf: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetProviderJSON gets provider info

Fetch provider information how to configure and bootstrap the VPN
*/
func (a *Client) GetProviderJSON(params *GetProviderJSONParams, opts ...ClientOption) (*GetProviderJSONOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetProviderJSONParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetProviderJSON",
		Method:             "GET",
		PathPattern:        "/provider.json",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetProviderJSONReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetProviderJSONOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetProviderJSON: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
