# coding: utf-8
lib = File.expand_path('../lib', __FILE__)
$LOAD_PATH.unshift(lib) unless $LOAD_PATH.include?(lib)
require 'numru/fftw3/version'

Gem::Specification.new do |spec|
  spec.name          = "ruby-fftw3"
  spec.version       = NumRu::FFTW3::VERSION
  spec.authors       = ["Takeshi Horinouchi"]
  spec.email         = ['eriko@gfd-dennou.org']

  spec.summary          = %q{The Ruby interface of the FFTW (ver 3) library}
  spec.description      = %q{Fast Fourier Transforms by using FFTW Ver.3. This new version works with Ruby2.0.}
  spec.homepage         = 'http://www.gfd-dennou.org/arch/ruby/products/ruby-fftw3/'
  spec.licenses         = ["BSD-2-Clause"]

  spec.files            = `git ls-files -z`.split("\x0")
  spec.test_files       = spec.files.grep(%r{^test/})
  spec.require_paths = ["ext","lib"]

  spec.required_ruby_version = Gem::Requirement.new(">= 1.8")
  spec.add_runtime_dependency(%q<narray>, [">= 0"])

  spec.extensions << "ext/numru/fftw3/extconf.rb"
end
