// Copyright 2016 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution and at
// http://rust-lang.org/COPYRIGHT.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

#![feature(slice_patterns)]

enum Void {}

fn main() {
    let x: Result<u32, &'static Void> = Ok(23);
    let _ = match x {   //~ ERROR non-exhaustive
        Ok(n) => n,
    };

    let x: &Void = unsafe { std::mem::uninitialized() };
    let _ = match x {}; //~ ERROR non-exhaustive

    let x: (Void,) = unsafe { std::mem::uninitialized() };
    let _ = match x {}; //~ ERROR non-exhaustive

    let x: [Void; 1] = unsafe { std::mem::uninitialized() };
    let _ = match x {}; //~ ERROR non-exhaustive

    let x: &[Void] = unsafe { std::mem::uninitialized() };
    let _ = match x {   //~ ERROR non-exhaustive
        &[] => (),
    };

    let x: Void = unsafe { std::mem::uninitialized() };
    let _ = match x {}; // okay

    let x: Result<u32, Void> = Ok(23);
    let _ = match x {   //~ ERROR non-exhaustive
        Ok(x) => x,
    };

    let x: Result<u32, Void> = Ok(23);
    let Ok(x) = x;
    //~^ ERROR refutable
}
