// This file is auto-generated by the build script
// Please, do not modify it manually

extern crate pulldown_cmark;


    #[test]
    fn spec_test_1() {
        let original = r##"Test header
-----------
"##;
        let expected = r##"<h2>Test header</h2>
"##;

        use pulldown_cmark::{Parser, html, Options, OPTION_ENABLE_TABLES, OPTION_ENABLE_FOOTNOTES};

        let mut s = String::new();

        let mut opts = Options::empty();
        opts.insert(OPTION_ENABLE_TABLES);
        opts.insert(OPTION_ENABLE_FOOTNOTES);

        let p = Parser::new_ext(&original, opts);
        html::push_html(&mut s, p);

        assert_eq!(expected, s);
    }

    #[test]
    fn spec_test_2() {
        let original = r##"Test|Table
----|-----
"##;
        let expected = r##"<table><thead><tr><td>Test</td><td>Table</td></tr></thead>
</table>
"##;

        use pulldown_cmark::{Parser, html, Options, OPTION_ENABLE_TABLES, OPTION_ENABLE_FOOTNOTES};

        let mut s = String::new();

        let mut opts = Options::empty();
        opts.insert(OPTION_ENABLE_TABLES);
        opts.insert(OPTION_ENABLE_FOOTNOTES);

        let p = Parser::new_ext(&original, opts);
        html::push_html(&mut s, p);

        assert_eq!(expected, s);
    }

    #[test]
    fn spec_test_3() {
        let original = r##"Test|Table
----|-----
Test row
Test|2

Test ending
"##;
        let expected = r##"<table><thead><tr><td>Test</td><td>Table</td></tr></thead>
<tr><td>Test row</td></tr>
<tr><td>Test</td><td>2</td></tr>
</table>
<p>Test ending</p>
"##;

        use pulldown_cmark::{Parser, html, Options, OPTION_ENABLE_TABLES, OPTION_ENABLE_FOOTNOTES};

        let mut s = String::new();

        let mut opts = Options::empty();
        opts.insert(OPTION_ENABLE_TABLES);
        opts.insert(OPTION_ENABLE_FOOTNOTES);

        let p = Parser::new_ext(&original, opts);
        html::push_html(&mut s, p);

        assert_eq!(expected, s);
    }

    #[test]
    fn spec_test_4() {
        let original = r##"> Test  | Table
> ------|------
> Row 1 | Every
> Row 2 | Day
>
> Paragraph
"##;
        let expected = r##"<blockquote>
<table><thead><tr><td>Test  </td><td> Table</td></tr></thead>
<tr><td>Row 1 </td><td> Every</td></tr>
<tr><td>Row 2 </td><td> Day</td></tr>
</table>
<p>Paragraph</p>
</blockquote>
"##;

        use pulldown_cmark::{Parser, html, Options, OPTION_ENABLE_TABLES, OPTION_ENABLE_FOOTNOTES};

        let mut s = String::new();

        let mut opts = Options::empty();
        opts.insert(OPTION_ENABLE_TABLES);
        opts.insert(OPTION_ENABLE_FOOTNOTES);

        let p = Parser::new_ext(&original, opts);
        html::push_html(&mut s, p);

        assert_eq!(expected, s);
    }

    #[test]
    fn spec_test_5() {
        let original = r##" 1. First entry
 2. Second entry

    Col 1|Col 2
    -|-
    Row 1|Part 2
    Row 2|Part 2
"##;
        let expected = r##"<ol>
<li>
<p>First entry</p>
</li>
<li>
<p>Second entry</p>
<table><thead><tr><td>Col 1</td><td>Col 2</td></tr></thead>
<tr><td>Row 1</td><td>Part 2</td></tr>
<tr><td>Row 2</td><td>Part 2</td></tr>
</table>
</li>
</ol>
"##;

        use pulldown_cmark::{Parser, html, Options, OPTION_ENABLE_TABLES, OPTION_ENABLE_FOOTNOTES};

        let mut s = String::new();

        let mut opts = Options::empty();
        opts.insert(OPTION_ENABLE_TABLES);
        opts.insert(OPTION_ENABLE_FOOTNOTES);

        let p = Parser::new_ext(&original, opts);
        html::push_html(&mut s, p);

        assert_eq!(expected, s);
    }

    #[test]
    fn spec_test_6() {
        let original = r##"|Col 1|Col 2|
|-----|-----|
|R1C1 |R1C2 |
|R2C1 |R2C2 |
"##;
        let expected = r##"<table><thead><tr><td>Col 1</td><td>Col 2</td></tr></thead>
<tr><td>R1C1 </td><td>R1C2 </td></tr>
<tr><td>R2C1 </td><td>R2C2 </td></tr>
</table>
"##;

        use pulldown_cmark::{Parser, html, Options, OPTION_ENABLE_TABLES, OPTION_ENABLE_FOOTNOTES};

        let mut s = String::new();

        let mut opts = Options::empty();
        opts.insert(OPTION_ENABLE_TABLES);
        opts.insert(OPTION_ENABLE_FOOTNOTES);

        let p = Parser::new_ext(&original, opts);
        html::push_html(&mut s, p);

        assert_eq!(expected, s);
    }

    #[test]
    fn spec_test_7() {
        let original = r##"| Col 1 | Col 2 |
|-------|-------|
|       |       |
|       |       |
"##;
        let expected = r##"<table><thead><tr><td> Col 1 </td><td> Col 2 </td></tr></thead>
<tr><td>       </td><td>       </td></tr>
<tr><td>       </td><td>       </td></tr>
</table>
"##;

        use pulldown_cmark::{Parser, html, Options, OPTION_ENABLE_TABLES, OPTION_ENABLE_FOOTNOTES};

        let mut s = String::new();

        let mut opts = Options::empty();
        opts.insert(OPTION_ENABLE_TABLES);
        opts.insert(OPTION_ENABLE_FOOTNOTES);

        let p = Parser::new_ext(&original, opts);
        html::push_html(&mut s, p);

        assert_eq!(expected, s);
    }

    #[test]
    fn spec_test_8() {
        let original = r##"| Col 1 | Col 2 |
|-------|-------|
|   x   |       |
|       |    x  |
"##;
        let expected = r##"<table><thead><tr><td> Col 1 </td><td> Col 2 </td></tr></thead>
<tr><td>   x   </td><td>       </td></tr>
<tr><td>       </td><td>    x  </td></tr>
</table>
"##;

        use pulldown_cmark::{Parser, html, Options, OPTION_ENABLE_TABLES, OPTION_ENABLE_FOOTNOTES};

        let mut s = String::new();

        let mut opts = Options::empty();
        opts.insert(OPTION_ENABLE_TABLES);
        opts.insert(OPTION_ENABLE_FOOTNOTES);

        let p = Parser::new_ext(&original, opts);
        html::push_html(&mut s, p);

        assert_eq!(expected, s);
    }

    #[test]
    fn spec_test_9() {
        let original = r##"|Col 1|Col 2|
|-----|-----|
|✓    |✓    |
|✓    |✓    |
"##;
        let expected = r##"<table><thead><tr><td>Col 1</td><td>Col 2</td></tr></thead>
<tr><td>✓    </td><td>✓    </td></tr>
<tr><td>✓    </td><td>✓    </td></tr>
</table>
"##;

        use pulldown_cmark::{Parser, html, Options, OPTION_ENABLE_TABLES, OPTION_ENABLE_FOOTNOTES};

        let mut s = String::new();

        let mut opts = Options::empty();
        opts.insert(OPTION_ENABLE_TABLES);
        opts.insert(OPTION_ENABLE_FOOTNOTES);

        let p = Parser::new_ext(&original, opts);
        html::push_html(&mut s, p);

        assert_eq!(expected, s);
    }

    #[test]
    fn spec_test_10() {
        let original = r##"|  Target                       | std |rustc|cargo| notes                      |
|-------------------------------|-----|-----|-----|----------------------------|
| `x86_64-unknown-linux-musl`   |  ✓  |     |     | 64-bit Linux with MUSL     |
| `arm-linux-androideabi`       |  ✓  |     |     | ARM Android                |
| `arm-unknown-linux-gnueabi`   |  ✓  |  ✓  |     | ARM Linux (2.6.18+)        |
| `arm-unknown-linux-gnueabihf` |  ✓  |  ✓  |     | ARM Linux (2.6.18+)        |
| `aarch64-unknown-linux-gnu`   |  ✓  |     |     | ARM64 Linux (2.6.18+)      |
| `mips-unknown-linux-gnu`      |  ✓  |     |     | MIPS Linux (2.6.18+)       |
| `mipsel-unknown-linux-gnu`    |  ✓  |     |     | MIPS (LE) Linux (2.6.18+)  |
"##;
        let expected = r##"<table><thead><tr><td>  Target                       </td><td> std </td><td>rustc</td><td>cargo</td><td> notes                      </td></tr></thead>
<tr><td> <code>x86_64-unknown-linux-musl</code>   </td><td>  ✓  </td><td>     </td><td>     </td><td> 64-bit Linux with MUSL     </td></tr>
<tr><td> <code>arm-linux-androideabi</code>       </td><td>  ✓  </td><td>     </td><td>     </td><td> ARM Android                </td></tr>
<tr><td> <code>arm-unknown-linux-gnueabi</code>   </td><td>  ✓  </td><td>  ✓  </td><td>     </td><td> ARM Linux (2.6.18+)        </td></tr>
<tr><td> <code>arm-unknown-linux-gnueabihf</code> </td><td>  ✓  </td><td>  ✓  </td><td>     </td><td> ARM Linux (2.6.18+)        </td></tr>
<tr><td> <code>aarch64-unknown-linux-gnu</code>   </td><td>  ✓  </td><td>     </td><td>     </td><td> ARM64 Linux (2.6.18+)      </td></tr>
<tr><td> <code>mips-unknown-linux-gnu</code>      </td><td>  ✓  </td><td>     </td><td>     </td><td> MIPS Linux (2.6.18+)       </td></tr>
<tr><td> <code>mipsel-unknown-linux-gnu</code>    </td><td>  ✓  </td><td>     </td><td>     </td><td> MIPS (LE) Linux (2.6.18+)  </td></tr>
</table>
"##;

        use pulldown_cmark::{Parser, html, Options, OPTION_ENABLE_TABLES, OPTION_ENABLE_FOOTNOTES};

        let mut s = String::new();

        let mut opts = Options::empty();
        opts.insert(OPTION_ENABLE_TABLES);
        opts.insert(OPTION_ENABLE_FOOTNOTES);

        let p = Parser::new_ext(&original, opts);
        html::push_html(&mut s, p);

        assert_eq!(expected, s);
    }

    #[test]
    fn spec_test_11() {
        let original = r##"|-|-|
|ぃ|い|
"##;
        let expected = r##"<p>|-|-|
|ぃ|い|</p>
"##;

        use pulldown_cmark::{Parser, html, Options, OPTION_ENABLE_TABLES, OPTION_ENABLE_FOOTNOTES};

        let mut s = String::new();

        let mut opts = Options::empty();
        opts.insert(OPTION_ENABLE_TABLES);
        opts.insert(OPTION_ENABLE_FOOTNOTES);

        let p = Parser::new_ext(&original, opts);
        html::push_html(&mut s, p);

        assert_eq!(expected, s);
    }

    #[test]
    fn spec_test_12() {
        let original = r##"|ぁ|ぃ|
|-|-|
|ぃ|ぃ|
"##;
        let expected = r##"<table><thead><tr><td>ぁ</td><td>ぃ</td></tr></thead>
<tr><td>ぃ</td><td>ぃ</td></tr>
</table>
"##;

        use pulldown_cmark::{Parser, html, Options, OPTION_ENABLE_TABLES, OPTION_ENABLE_FOOTNOTES};

        let mut s = String::new();

        let mut opts = Options::empty();
        opts.insert(OPTION_ENABLE_TABLES);
        opts.insert(OPTION_ENABLE_FOOTNOTES);

        let p = Parser::new_ext(&original, opts);
        html::push_html(&mut s, p);

        assert_eq!(expected, s);
    }

    #[test]
    fn spec_test_13() {
        let original = r##"|Колонка 1|Колонка 2|
|---------|---------|
|Ячейка 1 |Ячейка 2 |
"##;
        let expected = r##"<table><thead><tr><td>Колонка 1</td><td>Колонка 2</td></tr></thead>
<tr><td>Ячейка 1 </td><td>Ячейка 2 </td></tr>
</table>
"##;

        use pulldown_cmark::{Parser, html, Options, OPTION_ENABLE_TABLES, OPTION_ENABLE_FOOTNOTES};

        let mut s = String::new();

        let mut opts = Options::empty();
        opts.insert(OPTION_ENABLE_TABLES);
        opts.insert(OPTION_ENABLE_FOOTNOTES);

        let p = Parser::new_ext(&original, opts);
        html::push_html(&mut s, p);

        assert_eq!(expected, s);
    }