A reference has a longer lifetime than the data it references.

Erroneous code example:

```compile_fail,E0491
trait SomeTrait<'a> {
    type Output;
}

impl<'a, T> SomeTrait<'a> for T {
    type Output = &'a T; // compile error E0491
}
```

Here, the problem is that a reference type like `&'a T` is only valid
if all the data in T outlives the lifetime `'a`. But this impl as written
is applicable to any lifetime `'a` and any type `T` -- we have no guarantee
that `T` outlives `'a`. To fix this, you can add a where clause like
`where T: 'a`.

```
trait SomeTrait<'a> {
    type Output;
}

impl<'a, T> SomeTrait<'a> for T
where
    T: 'a,
{
    type Output = &'a T; // compile error E0491
}
```
