/* This file was generated by SableCC (http://www.sablecc.org/). */

package org.sablecc.sablecc.lexer;

import java.io.*;
import java.util.*;
import org.sablecc.sablecc.node.*;

public class Lexer
{
  protected Token token;
  protected State state = State.NORMAL;

  private PushbackReader in;
  private int line;
  private int pos;
  private boolean cr;
  private boolean eof;
  private final StringBuffer text = new StringBuffer();

  protected void filter() throws LexerException, IOException
    {}

  public Lexer(PushbackReader in)
  {
    this.in = in;
  }

  public Token peek() throws LexerException, IOException
  {
    while(token == null)
    {
      token = getToken();
      filter();
    }

    return token;
  }

  public Token next() throws LexerException, IOException
  {
    while(token == null)
    {
      token = getToken();
      filter();
    }

    Token result = token;
    token = null;
    return result;
  }

  protected Token getToken() throws IOException, LexerException
  {
    int dfa_state = 0;

    int start_pos = pos;
    int start_line = line;

    int accept_state = -1;
    int accept_token = -1;
    int accept_length = -1;
    int accept_pos = -1;
    int accept_line = -1;

    int[][][] gotoTable = this.gotoTable[state.id()];
    int[] accept = this.accept[state.id()];
    text.setLength(0);

    while(true)
    {
      int c = getChar();

      if(c != -1)
      {
        switch(c)
        {
        case 10:
          if(cr)
          {
            cr = false;
          }
          else
          {
            line++;
            pos = 0;
          }
          break;
        case 13:
          line++;
          pos = 0;
          cr = true;
          break;
        default:
          pos++;
          cr = false;
          break;
        };

        text.append((char) c);

        do
        {
          int oldState = (dfa_state < -1) ? (-2 -dfa_state) : dfa_state;

          dfa_state = -1;

          int[][] tmp1 =  gotoTable[oldState];
          int low = 0;
          int high = tmp1.length - 1;

          while(low <= high)
          {
            int middle = (low + high) / 2;
            int[] tmp2 = tmp1[middle];

            if(c < tmp2[0])
            {
              high = middle - 1;
            }
            else if(c > tmp2[1])
            {
              low = middle + 1;
            }
            else
            {
              dfa_state = tmp2[2];
              break;
            }
          }
        }
        while(dfa_state < -1);
      }
      else
      {
        dfa_state = -1;
      }

      if(dfa_state >= 0)
      {
        if(accept[dfa_state] != -1)
        {
          accept_state = dfa_state;
          accept_token = accept[dfa_state];
          accept_length = text.length();
          accept_pos = pos;
          accept_line = line;
        }
      }
      else
      {
        if(accept_state != -1)
        {
          switch(accept_token)
          {
          case 0:
            {
              Token token = new0(
                              getText(accept_length),
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              switch(state.id())
              {
              case 1:
                state = State.PACKAGE;
                break;
              }
              return token;
            }
          case 1:
            {
              Token token = new1(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              switch(state.id())
              {
              case 0:
                state = State.PACKAGE;
                break;
              }
              return token;
            }
          case 2:
            {
              Token token = new2(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 3:
            {
              Token token = new3(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 4:
            {
              Token token = new4(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 5:
            {
              Token token = new5(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 6:
            {
              Token token = new6(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 7:
            {
              Token token = new7(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 8:
            {
              Token token = new8(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 9:
            {
              Token token = new9(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 10:
            {
              Token token = new10(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 11:
            {
              Token token = new11(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 12:
            {
              Token token = new12(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 13:
            {
              Token token = new13(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 14:
            {
              Token token = new14(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 15:
            {
              Token token = new15(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 16:
            {
              Token token = new16(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              switch(state.id())
              {
              case 0:
                state = State.NORMAL;
                break;
              case 1:
                state = State.NORMAL;
                break;
              }
              return token;
            }
          case 17:
            {
              Token token = new17(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 18:
            {
              Token token = new18(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 19:
            {
              Token token = new19(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 20:
            {
              Token token = new20(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 21:
            {
              Token token = new21(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 22:
            {
              Token token = new22(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 23:
            {
              Token token = new23(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 24:
            {
              Token token = new24(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 25:
            {
              Token token = new25(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 26:
            {
              Token token = new26(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 27:
            {
              Token token = new27(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 28:
            {
              Token token = new28(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 29:
            {
              Token token = new29(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 30:
            {
              Token token = new30(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 31:
            {
              Token token = new31(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 32:
            {
              Token token = new32(
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 33:
            {
              Token token = new33(
                              getText(accept_length),
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 34:
            {
              Token token = new34(
                              getText(accept_length),
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 35:
            {
              Token token = new35(
                              getText(accept_length),
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 36:
            {
              Token token = new36(
                              getText(accept_length),
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 37:
            {
              Token token = new37(
                              getText(accept_length),
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 38:
            {
              Token token = new38(
                              getText(accept_length),
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          case 39:
            {
              Token token = new39(
                              getText(accept_length),
                              start_line + 1,
                              start_pos + 1);
              pushBack(accept_length);
              pos = accept_pos;
              line = accept_line;
              return token;
            }
          }
        }
        else
        {
          if(text.length() > 0)
          {
            throw new LexerException(
              "[" + (start_line + 1) + "," + (start_pos + 1) + "]" +
              " Unknown token: " + text);
          }
          else
          {
            EOF token = new EOF(
                          start_line + 1,
                          start_pos + 1);
            return token;
          }
        }
      }
    }
  }

  Token new0(String text, int line, int pos)
  {
    return new TPkgId(text, line, pos);
  }
  Token new1(int line, int pos)
  {
    return new TPackage(line, pos);
  }
  Token new2(int line, int pos)
  {
    return new TStates(line, pos);
  }
  Token new3(int line, int pos)
  {
    return new THelpers(line, pos);
  }
  Token new4(int line, int pos)
  {
    return new TTokens(line, pos);
  }
  Token new5(int line, int pos)
  {
    return new TIgnored(line, pos);
  }
  Token new6(int line, int pos)
  {
    return new TProductions(line, pos);
  }
  Token new7(int line, int pos)
  {
    return new TAbstract(line, pos);
  }
  Token new8(int line, int pos)
  {
    return new TSyntax(line, pos);
  }
  Token new9(int line, int pos)
  {
    return new TTree(line, pos);
  }
  Token new10(int line, int pos)
  {
    return new TNew(line, pos);
  }
  Token new11(int line, int pos)
  {
    return new TNull(line, pos);
  }
  Token new12(int line, int pos)
  {
    return new TTokenSpecifier(line, pos);
  }
  Token new13(int line, int pos)
  {
    return new TProductionSpecifier(line, pos);
  }
  Token new14(int line, int pos)
  {
    return new TDot(line, pos);
  }
  Token new15(int line, int pos)
  {
    return new TDDot(line, pos);
  }
  Token new16(int line, int pos)
  {
    return new TSemicolon(line, pos);
  }
  Token new17(int line, int pos)
  {
    return new TEqual(line, pos);
  }
  Token new18(int line, int pos)
  {
    return new TLBkt(line, pos);
  }
  Token new19(int line, int pos)
  {
    return new TRBkt(line, pos);
  }
  Token new20(int line, int pos)
  {
    return new TLPar(line, pos);
  }
  Token new21(int line, int pos)
  {
    return new TRPar(line, pos);
  }
  Token new22(int line, int pos)
  {
    return new TLBrace(line, pos);
  }
  Token new23(int line, int pos)
  {
    return new TRBrace(line, pos);
  }
  Token new24(int line, int pos)
  {
    return new TPlus(line, pos);
  }
  Token new25(int line, int pos)
  {
    return new TMinus(line, pos);
  }
  Token new26(int line, int pos)
  {
    return new TQMark(line, pos);
  }
  Token new27(int line, int pos)
  {
    return new TStar(line, pos);
  }
  Token new28(int line, int pos)
  {
    return new TBar(line, pos);
  }
  Token new29(int line, int pos)
  {
    return new TComma(line, pos);
  }
  Token new30(int line, int pos)
  {
    return new TSlash(line, pos);
  }
  Token new31(int line, int pos)
  {
    return new TArrow(line, pos);
  }
  Token new32(int line, int pos)
  {
    return new TColon(line, pos);
  }
  Token new33(String text, int line, int pos)
  {
    return new TId(text, line, pos);
  }
  Token new34(String text, int line, int pos)
  {
    return new TChar(text, line, pos);
  }
  Token new35(String text, int line, int pos)
  {
    return new TDecChar(text, line, pos);
  }
  Token new36(String text, int line, int pos)
  {
    return new THexChar(text, line, pos);
  }
  Token new37(String text, int line, int pos)
  {
    return new TString(text, line, pos);
  }
  Token new38(String text, int line, int pos)
  {
    return new TBlank(text, line, pos);
  }
  Token new39(String text, int line, int pos)
  {
    return new TComment(text, line, pos);
  }

  private int getChar() throws IOException
  {
    if(eof)
    {
      return -1;
    }

    int result = in.read();

    if(result == -1)
    {
      eof = true;
    }

    return result;
  }

  private void pushBack(int acceptLength) throws IOException
  {
    int length = text.length();
    for(int i = length - 1; i >= acceptLength; i--)
    {
      eof = false;

      in.unread(text.charAt(i));
    }
  }

  protected void unread(Token token) throws IOException
  {
    String text = token.getText();
    int length = text.length();

    for(int i = length - 1; i >= 0; i--)
    {
      eof = false;

      in.unread(text.charAt(i));
    }

    pos = token.getPos() - 1;
    line = token.getLine() - 1;
  }

  private String getText(int acceptLength)
  {
    StringBuffer s = new StringBuffer(acceptLength);
    for(int i = 0; i < acceptLength; i++)
    {
      s.append(text.charAt(i));
    }

    return s.toString();
  }

  private static int[][][][] gotoTable;
  /*  {
          { // NORMAL
              {{9, 9, 1}, {10, 10, 2}, {13, 13, 3}, {32, 32, 4}, {39, 39, 5}, {40, 40, 6}, {41, 41, 7}, {42, 42, 8}, {43, 43, 9}, {44, 44, 10}, {45, 45, 11}, {46, 46, 12}, {47, 47, 13}, {48, 48, 14}, {49, 57, 15}, {58, 58, 16}, {59, 59, 17}, {61, 61, 18}, {63, 63, 19}, {65, 65, 20}, {72, 72, 21}, {73, 73, 22}, {78, 78, 23}, {80, 80, 24}, {83, 83, 25}, {84, 84, 26}, {91, 91, 27}, {93, 93, 28}, {97, 122, 29}, {123, 123, 30}, {124, 124, 31}, {125, 125, 32}, },
              {{9, 32, -2}, },
              {{9, 32, -2}, },
              {{9, 9, 1}, {10, 10, 33}, {13, 32, -2}, },
              {{9, 32, -2}, },
              {{0, 9, 34}, {11, 12, 34}, {14, 38, 34}, {39, 39, 35}, {40, 65535, 34}, },
              {},
              {},
              {},
              {},
              {},
              {{62, 62, 36}, },
              {{46, 46, 37}, },
              {{42, 42, 38}, {47, 47, 39}, },
              {{48, 57, 15}, {88, 88, 40}, {120, 120, 41}, },
              {{48, 57, 15}, },
              {},
              {},
              {},
              {},
              {{98, 98, 42}, },
              {{101, 101, 43}, },
              {{103, 103, 44}, },
              {{101, 101, 45}, {117, 117, 46}, },
              {{97, 97, 47}, {114, 114, 48}, },
              {{116, 116, 49}, {121, 121, 50}, },
              {{111, 111, 51}, {114, 114, 52}, },
              {},
              {},
              {{48, 57, 53}, {95, 95, 54}, {97, 122, 55}, },
              {},
              {},
              {},
              {{9, 32, -2}, },
              {{0, 9, 56}, {11, 12, 56}, {14, 38, 56}, {39, 39, 57}, {40, 65535, 56}, },
              {{39, 39, 58}, },
              {},
              {},
              {{0, 41, 59}, {42, 42, 60}, {43, 65535, 59}, },
              {{0, 9, 61}, {10, 10, 62}, {11, 12, 61}, {13, 13, 63}, {14, 65535, 61}, },
              {{48, 57, 64}, {65, 70, 64}, {97, 102, 64}, },
              {{48, 102, -42}, },
              {{115, 115, 65}, },
              {{108, 108, 66}, },
              {{110, 110, 67}, },
              {{119, 119, 68}, },
              {{108, 108, 69}, },
              {{99, 99, 70}, },
              {{111, 111, 71}, },
              {{97, 97, 72}, },
              {{110, 110, 73}, },
              {{107, 107, 74}, },
              {{101, 101, 75}, },
              {{48, 122, -31}, },
              {{97, 122, 76}, },
              {{48, 122, -31}, },
              {{0, 38, -36}, {39, 39, 77}, {40, 65535, 56}, },
              {},
              {},
              {{0, 65535, -40}, },
              {{0, 41, 78}, {42, 42, 60}, {43, 46, 78}, {47, 47, 79}, {48, 65535, 78}, },
              {{0, 65535, -41}, },
              {},
              {{10, 10, 80}, },
              {{48, 102, -42}, },
              {{116, 116, 81}, },
              {{112, 112, 82}, },
              {{111, 111, 83}, },
              {},
              {{108, 108, 84}, },
              {{107, 107, 85}, },
              {{100, 100, 86}, },
              {{116, 116, 87}, },
              {{116, 116, 88}, },
              {{101, 101, 89}, },
              {{101, 101, 90}, },
              {{48, 57, 91}, {95, 95, 54}, {97, 122, 92}, },
              {},
              {{0, 41, 93}, {42, 42, 94}, {43, 65535, 93}, },
              {},
              {},
              {{114, 114, 95}, },
              {{101, 101, 96}, },
              {{114, 114, 97}, },
              {},
              {{97, 97, 98}, },
              {{117, 117, 99}, },
              {{101, 101, 100}, },
              {{97, 97, 101}, },
              {{110, 110, 102}, },
              {},
              {{48, 122, -78}, },
              {{48, 122, -78}, },
              {{0, 65535, -80}, },
              {{0, 41, 78}, {42, 42, 94}, {43, 65535, -62}, },
              {{97, 97, 103}, },
              {{114, 114, 104}, },
              {{101, 101, 105}, },
              {{103, 103, 106}, },
              {{99, 99, 107}, },
              {{115, 115, 108}, },
              {{120, 120, 109}, },
              {{115, 115, 110}, },
              {{99, 99, 111}, },
              {{115, 115, 112}, },
              {{100, 100, 113}, },
              {{101, 101, 114}, },
              {{116, 116, 115}, },
              {},
              {},
              {},
              {{116, 116, 116}, },
              {},
              {},
              {},
              {{105, 105, 117}, },
              {},
              {{111, 111, 118}, },
              {{110, 110, 119}, },
              {{115, 115, 120}, },
              {},
          }
          { // PACKAGE
              {{9, 9, 1}, {10, 10, 2}, {13, 13, 3}, {32, 32, 4}, {36, 36, 5}, {39, 39, 6}, {40, 40, 7}, {41, 41, 8}, {42, 42, 9}, {43, 43, 10}, {44, 44, 11}, {45, 45, 12}, {46, 46, 13}, {47, 47, 14}, {48, 48, 15}, {49, 57, 16}, {58, 58, 17}, {59, 59, 18}, {61, 61, 19}, {63, 63, 20}, {65, 65, 21}, {66, 71, 22}, {72, 72, 23}, {73, 73, 24}, {74, 77, 22}, {78, 78, 25}, {79, 79, 22}, {80, 80, 26}, {81, 82, 22}, {83, 83, 27}, {84, 84, 28}, {85, 90, 22}, {91, 91, 29}, {93, 93, 30}, {95, 95, 31}, {97, 122, 32}, {123, 123, 33}, {124, 124, 34}, {125, 125, 35}, },
              {{9, 32, -2}, },
              {{9, 32, -2}, },
              {{9, 9, 1}, {10, 10, 36}, {13, 32, -2}, },
              {{9, 32, -2}, },
              {{36, 36, 37}, {48, 57, 38}, {65, 90, 39}, {95, 95, 40}, {97, 122, 41}, },
              {{0, 9, 42}, {11, 12, 42}, {14, 38, 42}, {39, 39, 43}, {40, 65535, 42}, },
              {},
              {},
              {},
              {},
              {},
              {{62, 62, 44}, },
              {{46, 46, 45}, },
              {{42, 42, 46}, {47, 47, 47}, },
              {{48, 57, 16}, {88, 88, 48}, {120, 120, 49}, },
              {{48, 57, 16}, },
              {},
              {},
              {},
              {},
              {{36, 95, -7}, {97, 97, 41}, {98, 98, 50}, {99, 122, 41}, },
              {{36, 122, -7}, },
              {{36, 95, -7}, {97, 100, 41}, {101, 101, 51}, {102, 122, 41}, },
              {{36, 95, -7}, {97, 102, 41}, {103, 103, 52}, {104, 122, 41}, },
              {{36, 100, -25}, {101, 101, 53}, {102, 116, 41}, {117, 117, 54}, {118, 122, 41}, },
              {{36, 95, -7}, {97, 113, 41}, {114, 114, 55}, {115, 122, 41}, },
              {{36, 95, -7}, {97, 115, 41}, {116, 116, 56}, {117, 120, 41}, {121, 121, 57}, {122, 122, 41}, },
              {{36, 95, -7}, {97, 110, 41}, {111, 111, 58}, {112, 113, 41}, {114, 114, 59}, {115, 122, 41}, },
              {},
              {},
              {{36, 122, -7}, },
              {{36, 36, 37}, {48, 57, 60}, {65, 90, 39}, {95, 95, 61}, {97, 122, 62}, },
              {},
              {},
              {},
              {{9, 32, -2}, },
              {{36, 122, -7}, },
              {{36, 122, -7}, },
              {{36, 122, -7}, },
              {{36, 122, -7}, },
              {{36, 122, -7}, },
              {{0, 9, 63}, {11, 12, 63}, {14, 38, 63}, {39, 39, 64}, {40, 65535, 63}, },
              {{39, 39, 65}, },
              {},
              {},
              {{0, 41, 66}, {42, 42, 67}, {43, 65535, 66}, },
              {{0, 9, 68}, {10, 10, 69}, {11, 12, 68}, {13, 13, 70}, {14, 65535, 68}, },
              {{48, 57, 71}, {65, 70, 71}, {97, 102, 71}, },
              {{48, 102, -50}, },
              {{36, 95, -7}, {97, 114, 41}, {115, 115, 72}, {116, 122, 41}, },
              {{36, 95, -7}, {97, 107, 41}, {108, 108, 73}, {109, 122, 41}, },
              {{36, 95, -7}, {97, 109, 41}, {110, 110, 74}, {111, 122, 41}, },
              {{36, 95, -7}, {97, 118, 41}, {119, 119, 75}, {120, 122, 41}, },
              {{36, 107, -53}, {108, 108, 76}, {109, 122, 41}, },
              {{36, 110, -30}, {111, 111, 77}, {112, 122, 41}, },
              {{36, 95, -7}, {97, 97, 78}, {98, 122, 41}, },
              {{36, 109, -54}, {110, 110, 79}, {111, 122, 41}, },
              {{36, 95, -7}, {97, 106, 41}, {107, 107, 80}, {108, 122, 41}, },
              {{36, 100, -25}, {101, 101, 81}, {102, 122, 41}, },
              {{36, 122, -34}, },
              {{36, 95, -7}, {97, 122, 82}, },
              {{36, 122, -34}, },
              {{0, 38, -44}, {39, 39, 83}, {40, 65535, 63}, },
              {},
              {},
              {{0, 65535, -48}, },
              {{0, 41, 84}, {42, 42, 67}, {43, 46, 84}, {47, 47, 85}, {48, 65535, 84}, },
              {{0, 65535, -49}, },
              {},
              {{10, 10, 86}, },
              {{48, 102, -50}, },
              {{36, 115, -29}, {116, 116, 87}, {117, 122, 41}, },
              {{36, 95, -7}, {97, 111, 41}, {112, 112, 88}, {113, 122, 41}, },
              {{36, 110, -30}, {111, 111, 89}, {112, 122, 41}, },
              {{36, 122, -7}, },
              {{36, 107, -53}, {108, 108, 90}, {109, 122, 41}, },
              {{36, 95, -7}, {97, 99, 41}, {100, 100, 91}, {101, 122, 41}, },
              {{36, 115, -29}, {116, 116, 92}, {117, 122, 41}, },
              {{36, 115, -29}, {116, 116, 93}, {117, 122, 41}, },
              {{36, 100, -25}, {101, 101, 94}, {102, 122, 41}, },
              {{36, 100, -25}, {101, 101, 95}, {102, 122, 41}, },
              {{36, 36, 37}, {48, 57, 96}, {65, 95, -34}, {97, 122, 97}, },
              {},
              {{0, 41, 98}, {42, 42, 99}, {43, 65535, 98}, },
              {},
              {},
              {{36, 113, -28}, {114, 114, 100}, {115, 122, 41}, },
              {{36, 100, -25}, {101, 101, 101}, {102, 122, 41}, },
              {{36, 113, -28}, {114, 114, 102}, {115, 122, 41}, },
              {{36, 122, -7}, },
              {{36, 95, -7}, {97, 116, 41}, {117, 117, 103}, {118, 122, 41}, },
              {{36, 100, -25}, {101, 101, 104}, {102, 122, 41}, },
              {{36, 95, -7}, {97, 97, 105}, {98, 122, 41}, },
              {{36, 109, -54}, {110, 110, 106}, {111, 122, 41}, },
              {{36, 122, -7}, },
              {{36, 122, -84}, },
              {{36, 122, -84}, },
              {{0, 65535, -86}, },
              {{0, 41, 84}, {42, 42, 99}, {43, 65535, -69}, },
              {{36, 95, -7}, {97, 97, 107}, {98, 122, 41}, },
              {{36, 113, -28}, {114, 114, 108}, {115, 122, 41}, },
              {{36, 100, -25}, {101, 101, 109}, {102, 122, 41}, },
              {{36, 95, -7}, {97, 98, 41}, {99, 99, 110}, {100, 122, 41}, },
              {{36, 114, -52}, {115, 115, 111}, {116, 122, 41}, },
              {{36, 95, -7}, {97, 119, 41}, {120, 120, 112}, {121, 122, 41}, },
              {{36, 114, -52}, {115, 115, 113}, {116, 122, 41}, },
              {{36, 98, -105}, {99, 99, 114}, {100, 122, 41}, },
              {{36, 114, -52}, {115, 115, 115}, {116, 122, 41}, },
              {{36, 99, -79}, {100, 100, 116}, {101, 122, 41}, },
              {{36, 115, -29}, {116, 116, 117}, {117, 122, 41}, },
              {{36, 122, -7}, },
              {{36, 122, -7}, },
              {{36, 122, -7}, },
              {{36, 115, -29}, {116, 116, 118}, {117, 122, 41}, },
              {{36, 122, -7}, },
              {{36, 122, -7}, },
              {{36, 95, -7}, {97, 104, 41}, {105, 105, 119}, {106, 122, 41}, },
              {{36, 122, -7}, },
              {{36, 110, -30}, {111, 111, 120}, {112, 122, 41}, },
              {{36, 109, -54}, {110, 110, 121}, {111, 122, 41}, },
              {{36, 114, -52}, {115, 115, 122}, {116, 122, 41}, },
              {{36, 122, -7}, },
          }
      };*/

  private static int[][] accept;
  /*  {
          // NORMAL
          {-1, 38, 38, 38, 38, -1, 20, 21, 27, 24, 29, 25, 14, 30, 35, 35, 32, 16, 17, 26, -1, -1, -1, -1, 13, -1, 12, 18, 19, 33, 22, 28, 23, 38, -1, -1, 31, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, 33, -1, 34, 34, -1, -1, -1, 39, 39, 36, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, 33, 37, -1, 39, 39, -1, -1, -1, 11, -1, -1, -1, -1, -1, 9, 33, 33, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2, 8, 4, -1, 3, 5, 1, -1, 7, -1, -1, -1, 6, },
          // PACKAGE
          {-1, 38, 38, 38, 38, 0, -1, 20, 21, 27, 24, 29, 25, 14, 30, 35, 35, 32, 16, 17, 26, 0, 0, 0, 0, 0, 0, 0, 0, 18, 19, 0, 0, 22, 28, 23, 38, 0, 0, 0, 0, 0, -1, -1, 31, 15, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 34, 34, -1, -1, -1, 39, 39, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, -1, 39, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
   
      };*/

  public static class State
  {
    public final static State NORMAL = new State(0);
    public final static State PACKAGE = new State(1);

    private int id;

    private State(int id)
    {
      this.id = id;
    }

    public int id()
    {
      return id;
    }
  }

  static
  {
    try
    {
      DataInputStream s = new DataInputStream(
                            new BufferedInputStream(
                              Lexer.class.getResourceAsStream("lexer.dat")));

      // read gotoTable
      int length = s.readInt();
      gotoTable = new int[length][][][];
      for(int i = 0; i < gotoTable.length; i++)
      {
        length = s.readInt();
        gotoTable[i] = new int[length][][];
        for(int j = 0; j < gotoTable[i].length; j++)
        {
          length = s.readInt();
          gotoTable[i][j] = new int[length][3];
          for(int k = 0; k < gotoTable[i][j].length; k++)
          {
            for(int l = 0; l < 3; l++)
            {
              gotoTable[i][j][k][l] = s.readInt();
            }
          }
        }
      }

      // read accept
      length = s.readInt();
      accept = new int[length][];
      for(int i = 0; i < accept.length; i++)
      {
        length = s.readInt();
        accept[i] = new int[length];
        for(int j = 0; j < accept[i].length; j++)
        {
          accept[i][j] = s.readInt();
        }
      }

      s.close();
    }
    catch(Exception e)
    {
      throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
    }
  }
}
