#!/bin/bash
# bbou@ac-toulouse.fr
# 28/08/2009  
# _uninstall-pam-core.sh

### P A R A M S
MYVERBOSE=
if [ "$1" == "-v" ];then
	export MYVERBOSE="True"
	echo "VERBOSE"
	shift
fi
if [ "$1" == "-t" ];then
	MYTEST="True"
	shift
else
	MYTEST=
fi
if [ "$1" == "-w" ];then
	MYDOWINBIND="True"
	shift
else
	MYDOWINBIND=
fi
if [ "$1" == "-h" ];then
	MYDOMKHOMEDIR="True"
	shift
else
	MYDOMKHOMEDIR=
fi
if [ "$1" == "-m" ];then
	MYDOMOUNT="True"
	shift
else
	MYDOMOUNT=
fi

MYMOUNTPOINT="$1"
#echo "mountpoint=${MYMOUNTPOINT}"

### M O D I F I E D   F I L E S ...

#echo "security=${PAMSERVICES} in ${PAMDIR}/" 

### ... W I T H   A C C E S S

INST_UID=root
INST_GID=root
INST_PAM_MOD=644

### I N C L U D E

. ./_include.sh

### O T H E R

services=${PAMSERVICES}
modes=${PAMMODES}
case ${DISTRIBUTION} in
	Redhat|Fedora|Mandriva)
		pamauthupdate=
		;;
	Suse)
		pamauthupdate=
		;;
	Debian|Ubuntu)
		pamauthupdate=True
		;;
	*)
		echo "Unsupported distribution" >&2
		exit 1
esac
#echo "services=${services}"
#echo "modes=${modes}"
#echo "pamauthupdate=${pamauthupdate}"

### S T A R T

# D I R
savedir=${TMPDIR}/pam.d.`date '+%Y%m%d%H%M%S'`
[ -d  ${savedir} ] || mkdir ${savedir}
tmpdir=${TMPDIR}/pam.d
[ -d  ${tmpdir} ] || mkdir ${tmpdir}

# U N C O N F I G U R E  P A M
pushd conf > /dev/null

# save all services
echo "+save ${services} samba in ${PAMDIR} to ${savedir}"
pushd ${PAMDIR} > /dev/null
cp ${services} samba ${savedir}/
popd > /dev/null

# copy all services
echo "+copy ${services} samba in ${PAMDIR} to ${tmpdir}"
pushd ${PAMDIR} > /dev/null
cp ${services} samba ${tmpdir}/
popd > /dev/null

# do it
if [ "${MYDOMOUNT}" == "True" ]; then
./unconfig-pam_mount.sh -f ${tmpdir} "${services}" "${modes}"
fi
if [ "${MYDOMKHOMEDIR}" == "True" ]; then
./unconfig-pam_mkhomedir.sh -f ${tmpdir} "${services}" "${modes}"
fi
sambaservice=
if [ "${MYDOWINBIND}" == "True" ]; then
sambaservice=samba
./unconfig-pam_samba.sh -f ${tmpdir}
./unconfig-pam_winbind.sh -f ${tmpdir} "${services}" "${modes}"
fi

# hook to debconf
./config-pam.sh

# U N C O N F I G U R E  P A M _ M O U N T
if [ "${MYDOMOUNT}" == "True" ]; then
	if [ -z "${MYTEST}" ]; then
		./unconfig-pam_mountconf.sh "${MYMOUNTPOINT}"
		./unconfig-netlink.sh
	fi
fi

pushd ${tmpdir} > /dev/null
if [ ! -z "${MYTEST}" ]; then
	# display
	if [ ! -z "${MYVERBOSE}" ];then
		for i in ${services} ${sambaservice}; do
			echo "----------------------------------------------------------------------"
			echo "#${i} (not effective on system)"
			echo ""
			cat ${i} | grep -v "^#" | grep -v "^$"
			echo "${i} not effective on system" >&2
		done
		echo "DIFFS"
		for i in ${services}  ${sambaservice}; do
			echo "----------------------------------------------------------------------"
			echo "#diff ${tmpdir}/${i} - ${PAMDIR}/${i}"
			echo ""
			diff ${tmpdir}/${i} ${PAMDIR}/${i}
		done
	fi
	echo "----------------------------------------------------------------------"
	popd > /dev/null
	popd > /dev/null
else
	# P R I V I L E G E
	if [ "$(whoami)" != "root" ]; then
		echo "User is $(whoami)"
		echo "This must be run as root" >&2
		exit 1
	fi

	# S T A T U S
	[ -d /var/lib/sadms ] || mkdir -p /var/lib/sadms
	echo '0' > /var/lib/sadms/pam

	#install
	if [ ! -z "${pamauthupdate}" ]; then
		services=
	fi
	for i in ${services}  ${sambaservice}; do
		echo "+install modified ${tmpdir}/${i} to ${PAMDIR}"
		${INSTALL} -o ${INST_UID} -g ${INST_GID} -m ${INST_PAM_MOD} ${i} ${PAMDIR}/ > /dev/null
	done
	
	popd > /dev/null
	popd > /dev/null
	
	# refresh
	./_refresh-pam.sh
fi
