/*
 *                            COPYRIGHT
 *
 *  sch-rnd - modular/flexible schematics editor - BXL format support
 *  Copyright (C) 2025 Tibor 'Igor2' Palinkas
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 31 Milk Street, # 960789 Boston, MA 02196 USA.
 *
 *  Contact:
 *    Project page: http://repo.hu/projects/sch-rnd
 *    contact lead developer: http://www.repo.hu/projects/sch-rnd/contact.html
 *    mailing list: http://www.repo.hu/projects/sch-rnd/contact.html
 */


#include <stdio.h>
#include <string.h>
#include <libcschem/config.h>
#include <libcschem/plug_io.h>
#include <librnd/core/plugins.h>
#include <librnd/core/conf_multi.h>
#include "read.h"

static csch_plug_io_t bxl;
static char bxl_cookie[] = "io_bxl";

#include "io_bxl_conf.h"
#include "conf_internal.c"

conf_io_bxl_t io_bxl_conf;

static int io_bxl_load_prio(const char *fn, const char *fmt, csch_plug_io_type_t type)
{
	if ((fmt != NULL) && (strstr(fmt, "bxl") != NULL)) {
		if (type == CSCH_IOTYP_GROUP)
			return 100;
		if (type == CSCH_IOTYP_SHEET)
			return 90;
		return 0;
	}

	if (fmt == NULL) {
		if (type == CSCH_IOTYP_GROUP)
			return 80;
		if (type == CSCH_IOTYP_SHEET) /* load symbol for direct edit */
			return 40;
	}

	return 0;
}

int pplg_check_ver_io_bxl(int ver_needed) { return 0; }

void pplg_uninit_io_bxl(void)
{
	csch_plug_io_unregister(&bxl);
	rnd_conf_plug_unreg("plugins/io_bxl/", io_bxl_conf_internal, bxl_cookie);
}

int pplg_init_io_bxl(void)
{
	RND_API_CHK_VER;

	bxl.name = "BXL symbol";
	bxl.load_prio = io_bxl_load_prio;
	bxl.load_sheet = io_bxl_load_sheet;
	bxl.load_grp = io_bxl_load_grp;
	bxl.test_parse = io_bxl_test_parse;

	csch_plug_io_register(&bxl);

	rnd_conf_plug_reg(io_bxl_conf, io_bxl_conf_internal, bxl_cookie);
#define conf_reg(field,isarray,type_name,cpath,cname,desc,flags) \
	rnd_conf_reg_field(io_bxl_conf, field,isarray,type_name,cpath,cname,desc,flags);
#include "io_bxl_conf_fields.h"

	return 0;
}

