// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2008 - INRIA - Serge Steer
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- CLI SHELL MODE -->

// Maple code used to create reference
// Digits := 40: 
// writeto("acoth.ref"): interface(prettyprint = 0):
// for i from 1+1/100 by 1/100  to 2 do print(i, evalf[30](arccoth(i), 30)) end do; 
// for i from 3 to 30 do print(i, evalf[30](arccoth(i), 30)) end do; 
// writeto(terminal):

// writeto("acothi.ref"): interface(prettyprint = 0):
// for i from 0 by 1/20  to 1-1/20 do print(i, evalf[30](Re(arccoth(i)), 30)) end do; 
// writeto(terminal):

ieee(2)
pi=%pi;eps=%eps;Inf=%inf;NaN=%nan; //used to make following code runnable under Matlab

ref=[101/100, 2.65165245402953787553265861664
51/50, 2.30756025842062972544209913346
103/100, 2.10729684518683882044668976944
26/25, 1.96591281636216288582238992740
21/20, 1.85678603335215390193338168652
53/50, 1.76805834978076303968667853907
107/100, 1.69340432210502788424594528111
27/25, 1.62904826901074102273535978151
109/100, 1.57255483731429581064024026800
11/10, 1.52226121886171149825029899018
111/100, 1.47698143033884797584000634374
28/25, 1.43583981244200607137461195105
113/100, 1.39817140412394418833560616394
57/50, 1.36345934270329643409952303679
23/20, 1.33129391351272636603879863821
29/25, 1.30134484272219188238425179465
117/100, 1.27334200474212173539249122506
59/50, 1.24706165244646215879341298918
119/100, 1.22231637532503018023916333124
6/5, 1.19894763639918527203097178898
121/100, 1.17682013189716490990121203954
61/50, 1.15581746425698179585069866499
123/100, 1.13583877776548453391467618896
31/25, 1.11679611075354711627228587472
5/4, 1.09861228866810969139524523692
63/50, 1.08121923062540191626432202603
127/100, 1.06455657573853680041382293303
32/25, 1.04857055938961842314945996268
129/100, 1.03321308678388281062898178579
13/10, 1.01844096363051999970575379744
131/100, 1.00421525301832364731668861689
33/25, .990500734433291704174403894723
133/100, .977265446049610164922518029891
67/50, .964480295370770019297221648769
27/20, .952118726327372640857798963164
34/25, .940156433284750033912779949937
137/100, .928571114245453370600047553686
69/50, .917342256972544462672929964714
139/100, .906450952900932119757215457887
7/5, .895879734614027500406238679190
141/100, .885612433393173595799823972837
71/50, .875634053936659045811644587782
143/100, .865930663823493016751691835633
36/25, .856489295687470352344722762730
29/20, .847297860387203613710107506521
73/50, .838345069721633902227627889075
147/100, .829620367458959304620782101840
37/25, .821113867628545622558343483081
149/100, .812816299177040502330005986664
3/2, .804718956217050187300379666613
151/100, .796813653203729057286902692106
38/25, .789092684464997975921177887861
153/100, .781548787587699200362113635373
77/50, .774175110227131099430852548474
31/20, .766965179962977613791418138415
39/25, .759912876872206620990403931924
157/100, .753012408530334823473760822975
79/50, .746258287187599043842407858953
159/100, .739645308896909149428699020377
8/5, .733168534396713522329121102321
161/100, .726823271574691080611186701391
81/50, .720605059358002649110129843314
163/100, .714509652893115931595041523458
41/25, .708533009893322153602746225257
33/20, .702671278045292549045490848732
83/50, .696920783377636764828595680222
167/100, .691278019504641735021494390614
42/25, .685739637667374989710268689245
169/100, .680302437502289862008977555881
17/10, .674963358474507884540191483662
171/100, .669719471919192739383707770346
43/25, .664567973639971003438138132743
173/100, .659506177018284301730988282246
87/50, .654531506591950235473547228474
7/4, .649641492065130426333349170521
44/25, .644833762715409461096485318422
177/100, .640106042166827325351050614058
89/50, .635456143500522664870026120194
179/100, .630881964677172067273354628453
9/5, .626381484247683997844060310993
181/100, .621952757330653499762828688502
91/50, .617593911836930237174716266829
183/100, .613303144923319850585257461752
46/25, .609078719658946212414428276074
37/20, .604918961889167035577369025469
93/50, .600822257283172428321294253092
187/100, .596787048552518695196799423598
47/25, .592811832828869728781505569398
189/100, .588895159190146161090626847538
19/10, .585035626325127322196390779258
191/100, .581231880327321236176563336809
48/25, .577482612609620719142678012814
193/100, .573786557931905684307715350674
97/50, .570142492534338857392500027018
39/20, .566549232369639495303511470916
49/25, .563005631428112067069193095596
197/100, .559510580149658398065478833514
99/50, .556063003917416265390861394109
199/100, .552661861628048250003903110783
2, .549306144334054845697622618461
3, .346573590279972654708616060729
4, .255412811882995341602757048152
5, .202732554054082190989006557732
6, .168236118310606465252296705108
7, .143841036225890463719609502997
8, .125657214140453038842568865201
9, .111571775657104877883147545155
10, .100335347731075580635726552060
11, 0.911607783969773131058590125773e-1
12, 0.835270423315830959957719318001e-1
13, 0.770753399136291521464376925312e-1
14, 0.715504218203366649712585642917e-1
15, 0.667656963122613115731718104657e-1
16, 0.625815714770030071267650238622e-1
17, 0.588915178281917272693970547353e-1
18, 0.556128175551121898797464070074e-1
19, 0.526802578289131506137504904197e-1
20, 0.500417292784912682457852742389e-1
21, 0.476550899021624300219760616404e-1
22, 0.454858891028633471530774257222e-1
23, 0.435056884948148830838829509369e-1
24, 0.416908044695255291973829173211e-1
25, 0.400213538367682129118889808632e-1
26, 0.384805205680641624921085221576e-1
27, 0.370539860768609392345487116680e-1
28, 0.357294819910724764987681607972e-1
29, 0.344964357434757257367098526237e-1
30, 0.333456872493361093729461460902e-1
];
refi=[0, 0.
1/20, 0.500417292784912682457852742389e-1
1/10, .100335347731075580635726552060
3/20, .151140435936466805278609106969
1/5, .202732554054082190989006557732
1/4, .255412811882995341602757048152
3/10, .309519604203111715474067349061
7/20, .365443754271396169066124134601
2/5, .423648930193601806855053753260
9/20, .484700278594051741560664227198
1/2, .549306144334054845697622618461
11/20, .618381313574463431569336925349
3/5, .693147180559945309417232121458
13/20, .775298706205583465175918035722
7/10, .867300527694053194427144690475
3/4, .972955074527656652552676371722
4/5, 1.09861228866810969139524523692
17/20, 1.25615281198805737648642521705
9/10, 1.47221948958322023000451371594
19/20, 1.83178082306482321372436633924
];

x=ref(:,1);
e=max(abs((ref(:,2)-acoth(x))./ref(:,2)));
if e>10*eps then pause,end

x=refi(:,1);
e=max(abs((refi(:,2)-imult(pi/2)-acoth(x))./(refi(:,2)-imult(pi/2))));
if e>10*eps then pause,end



x=-ref(:,1);
e=max(abs((-ref(:,2)-acoth(x))./ref(:,2)));
if e>10*eps then pause,end

x=-refi(:,1);
e=max(abs((-refi(:,2)-imult(pi/2)-acoth(x))./(-refi(:,2)-imult(pi/2))));
if e>10*eps then pause,end



if acoth(1)<>Inf then pause,end
if acoth(-1)<>-Inf then pause,end
if acoth(0)<>-imult(pi/2) then pause,end

if acoth([])<>[] then pause,end
if ~isnan(acoth(%nan)) then pause,end

