// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2008-2009 - INRIA - Michael Baudin
// Copyright (C) 2011 - DIGITEO - Michael Baudin
//
// Copyright (C) 2012 - 2016 - Scilab Enterprises
//
// This file is hereby licensed under the terms of the GNU GPL v2.0,
// pursuant to article 5.3.4 of the CeCILL v.2.1.
// This file was originally licensed under the terms of the CeCILL v2.1,
// and continues to be available under such terms.
// For more information, see the COPYING file which you should have received
// along with this program.

// <-- CLI SHELL MODE -->


function y = rosenbrock (x)
    y = 100*(x(2)-x(1)^2)^2 + (1-x(1))^2;
endfunction

//
// Pfeffer, case with x0 only
//
s1 = optimsimplex_new ( "pfeffer" , [-1.2 0.0] );
computed = optimsimplex_getall ( s1 );
expected = [
0.0      -1.2     0.
0.0  -1.26    0.
0.0  -1.2     0.0075
];
assert_checkalmostequal ( computed , expected , 1.e-6 );
s1 = optimsimplex_destroy ( s1 );

//
// Pfeffer, case with x0 and function
//
s1 = optimsimplex_new ( "pfeffer" , [-1.2 0.0] , rosenbrock );
computed = optimsimplex_getall ( s1 );
expected = [
212.2      -1.2     0.
257.15498  -1.26    0.
210.04562  -1.2     0.0075
];
assert_checkalmostequal ( computed , expected , 1.e-6 );
s1 = optimsimplex_destroy ( s1 );

//
// Pfeffer, case with specified deltas
//
s1 = optimsimplex_new ( "pfeffer" , [-1.2 0.0] , rosenbrock , 0.1 , 0.01 );
computed = optimsimplex_getall ( s1 );
expected = [
212.2      -1.2     0.
308.97818  -1.32    0.
209.33     -1.2     0.01
];
assert_checkalmostequal ( computed , expected , 1.e-6 );
s1 = optimsimplex_destroy ( s1 );

//
// Case with additional object
//
myobj = tlist(["T_MYSTUFF","nb"]);
myobj.nb = 0;
function [ y , myobj ] = mycostf ( x , myobj )
    y = rosenbrock(x);
    myobj.nb = myobj.nb + 1
endfunction
[ s1 , myobj ] = optimsimplex_new ( "pfeffer" , [-1.2 1.0] , mycostf , 0.05 , 0.0075 , myobj );
computed = optimsimplex_getall ( s1 );
expected = [
24.2       -1.2     1.
39.634976  -1.26    1.
20.05      -1.2     1.05
];
assert_checkalmostequal ( computed , expected , 10 * %eps );
assert_checkequal ( myobj.nb , 3 );
s1 = optimsimplex_destroy ( s1 );


