/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OPTIONS_H
#define OPTIONS_H

#include "intincl.h"

struct args_def_type {
  int id;
  char* name;
  unsigned int required :1;
};
#define ARGS_DEF_TYPE_LAST { -1, NULL, 0 }

enum args_param_type {
  ARGS_PARAM_NONE = 0, //no parameter allowed
  ARGS_PARAM_OPT, //parameter is optional, does not work with libpopt
  ARGS_PARAM_REQ //parameter is required
};

struct args_def {
  char* long_name; //long option name
  char short_name; //short option name, 0 for none
  char* env_var; //an environment variable to check
  enum args_param_type ptype; //parameter type

  /* for help output */
  char* pname; //parameter name
  int type_id; //see args_def_type
  char* descr; //description
  
};
#define ARGS_DEF_LAST { NULL, 0, NULL, ARGS_PARAM_NONE, NULL, -1, NULL }

/* return full path of filename with
 * the configuration directory as base
 * return value needs to be freed
 */
char* configfile_get_path (char* package, char* filename);

/* reads a config file located at filename
 * the config file must contain long-options only
 * seperator of option and arguments is '='
 * comments have a '#' at beginning of line
 */
int configfile_parse (char* filepath,
		      struct args_def* list,
		      void (*arg_fill) (int short_opt,
					const char* long_opt,
					char* argument));


/* include environment variables */
void use_envvars (struct args_def* list,
		  void (*arg_fill) (int short_opt,
				    const char* long_opt,
				    char* argument));

/* functions to fill the struct by parsing the command line
 * returns a NULL terminated list of files
 */
char** args_parse (int argc, char** argv,
		   struct args_def* list,
		   void (*arg_fill) (int short_opt,
				     const char* long_opt,
				     char* argument));

/** prints program syntax to stdout
 * @param me         the program name (path is ignored)
 * @param types      the list of global option types
 * @param params     the list of parameters allowed
 * @param extra_args extra arguments representation
 */
void help (char* me,
	   struct args_def_type* types,
	   struct args_def* params,
	   char* extra_args);

#endif
