/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/

#ifndef SCHEDULEDOPERATIONSKROOGOID_H
#define SCHEDULEDOPERATIONSKROOGOID_H
/** @file
* This file is Plasma Applet for Scheduled Operations Skroogoid
*
* @author Siddharth SHARMA
*/
#include <Plasma/Applet>
#include <Plasma/Label>
#include <QGraphicsLinearLayout>
#include <Plasma/Frame>


class QGraphicsGridLayout;
/**
 * Class ScheduledOperationSkroogoid
 */
class ScheduledOperationSkroogoid : public Plasma::Applet
{
    Q_OBJECT

public:
    /**
    * Default Constructor
    */
    explicit ScheduledOperationSkroogoid(QObject* iParent, const QVariantList& args);

    /**
     * Reimplemented from Plasma::Applet
     */
    virtual void init();

    /**
    * Default Destructor
    */
    ~ScheduledOperationSkroogoid();

private Q_SLOTS:
    /**
     * Fetch data from the specified source
     */
    void dataUpdated(const QString& sourceName, const Plasma::DataEngine::Data& engineData);

private:
    QGraphicsLinearLayout* widgetLayout;

    /**
     * Creates a Plasma::Frame for the specified date
     */
    Plasma::Frame* createFrame(const QString date);
};

/**
  * For exporting skroogoid as a registered Plasma Applet
  */
K_EXPORT_PLASMA_APPLET(scheduledoperationskroogoid, ScheduledOperationSkroogoid)

#endif
