11.1 API Básico

# API Básico de Minecraft Pi 

Sonic Pi actualmente soporta las siguientes interacciones básicas con Minecraft Pi:

* Mostrar mensajes de chat
* Establecer la posición del usuario
* Obtener la posición del usuario
* Establecer el tipo de bloque a una coordenada dada
* Obtener el tipo de coordenada a una coordenada dada

Veamos cada una de ellas ahora.

## Mostrnado mensajes de chat

Veamos cuán fácil es controlar Minecraft Pi desde Sonic Pi. Primero,
asegúrate de tener abiertos tanto Minecraft Pi como Sonic Pi al mismo
tiempo y haber entrado a un mundo de Minecraft en el que puedas caminar.

Escribe lo siguiente en un buffer vacío de Sonic Pi:

```
mc_message "Hello from Sonic Pi"
```

Cuando presiones el botón *Run*, verás tu mensaje en la ventana de Minecraft.
¡Felicidades, acabas de escribir tu primer código de Minecraft! ¿fácil, no?

## Estableciendo la posición del usuario

Hagamos un poco de magia. Teletransportémonos a alguna parte. Prueba lo siguiente:

```
mc_teleport 50, 50, 50
```

Cuando le das al botón *Run* - ¡boom! Te teletransporta a otro lugar. Lo más usual
es que sea un lugar en el cielo y que caigas en un lugar seco o en agua. Ahora,
¿cuáles eran esos números `50, 50, 50`? Esas son coordenadas de la posición a la que
te quieres teletransportar. Tommos un rato para explorar qué son esas coordenadas
y cómo trabajan, porque son muy, muy importantes para progrmar Minecraft..

## Coordenadas

Imagina un mapa pirata con una gran `X` marcando la localización de un tesoro.
La localización exacta de `X` puede ser descrita con dos números - cuán lejos en el
mapa de izquierda a derecha y qué tan lejos de arriba a abajo. Por ejemplo `10cm`
cruzando y `8cm` arriba. Estos dos números `10` y `8` son coordenadas. Fácilmente
podrías imaginar describir las localizaciones de otros tesoros con otros pares de
números. Quizás existe un enorme baúl de oro en `2` cruzando y `9` arriba...

Ahora, en Minecraft dos números no son suficientes. También necesitamos saber qué tan
alto nos encontramos. Por lo tanto necesitamos tres números:

* Cómo de lejos de derecha a izquierda en el mundo - `x`
* Cómo de lejos de frente hacia atrás en el mundo - `z`
* Cómo de alto estamos en el mundo - `y`

Una última cosa: típicamente describimos estas coordenadas en este orden:
`x`, `y`, `z`.

## Encontrando tus coordenadas actuales

Juguemos con las coordenadas. Navega a algún lugar bonito en el mapa de
Minecraft y después pásate a Sonic Pi. Ahora pon el siguiente código:

```
puts mc_location
```
Cuando presionas el botón *Run* verás las coordenadas de tu posición actual
en la ventan de la bitácora. Apúntalas, muévete adelante en el mundo y vuelve
a probar. ¡Nota que las coordenadas han cambiado! Ahora, yo recomiendo que
pases algún tiempo repitiendo esto exactamente - muévete un poco en el mundo, 
mira las coordenadas y repite. Hazlo hasta que sientas cómo cambian las
coordenadas cuando te mueves. Una vez lo entiendas, programar con el APi de 
Minecraft será un paseo.

## ¡Construyamos!

Ahora que ya sabes cómo encontrar la posición actual y teletransportarte 
utilizando las coordenadas, tienes entonces las herramientas necesarias 
para comenzar a construir cosas en Minecraft con código. Digamos que quieres
convertir en vidrio el bloque en las coordenadas `40`, `50`, `60`. Super fácil:

```
mc_set_block :glass, 40, 50, 60
```

Haha, fué realmente fácil. Para ver tu trabajo, simplemente teletranspórtate
a las cercanías y echa un vistazo:

```
mc_teleport 35, 50, 60
```
¡Ahora mira alrededor y deberías ver un bloque de vidrio! Intenta cambiarlo 
a diamante:

```
mc_set_block :diamond, 40, 50, 60
```

Si estabas mirando en la dirección correcta, puedes haberlo visto cambiar.
Es el comienzo de algo excitante...

## Viendo los bloques

Veamos lo último antes de movernos a algo más envolvente. Si damos un set
de coordenadas, podemos preguntarle a Minecraft qué tipo de bloque espeecífico
es. Intentémoslo con el bloque de diamante que acabamos de crear:

```
puts mc_get_block 40, 50, 60
```

Yey! Es `:diamond`. Intenta cambiandolo a glass y preguntar otra vez - 
¿dice `:glass`? Estoy seguro que si :-)

## Tipos de bloques disponibles

Antes de ponerte a programar en Minecraft Pi como un obseso, podrías ojear 
la siguiente lista de bloques disponibles:

        :air
        :stone
        :grass
        :dirt
        :cobblestone
        :wood_plank
        :sapling
        :bedrock
        :water_flowing
        :water
        :water_stationary
        :lava_flowing
        :lava
        :lava_stationary
        :sand
        :gravel
        :gold_ore
        :iron_ore
        :coal_ore
        :wood
        :leaves
        :glass
        :lapis
        :lapis_lazuli_block
        :sandstone
        :bed
        :cobweb
        :grass_tall
        :flower_yellow
        :flower_cyan
        :mushroom_brown
        :mushroom_red
        :gold_block
        :gold
        :iron_block
        :iron
        :stone_slab_double
        :stone_slab
        :brick
        :brick_block
        :tnt
        :bookshelf
        :moss_stone
        :obsidian
        :torch
        :fire
        :stairs_wood
        :chest
        :diamond_ore
        :diamond_block
        :diamond
        :crafting_table
        :farmland
        :furnace_inactive
        :furnace_active
        :door_wood
        :ladder
        :stairs_cobblestone
        :door_iron
        :redstone_ore
        :snow
        :ice
        :snow_block
        :cactus
        :clay
        :sugar_cane
        :fence
        :glowstone_block
        :bedrock_invisible
        :stone_brick
        :glass_pane
        :melon
        :fence_gate
        :glowing_obsidian
        :nether_reactor_core
