-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with ErrorHandler;
with E_Strings;
with LexTokenLists;
with LexTokenManager;
with SparkLex;
with SPARK_IO;
with STree;

use type LexTokenLists.Lists;
use type LexTokenManager.Str_Comp_Result;
use type SPARK_IO.File_Status;
use type STree.Iterator;

--# inherit CommandLineData,
--#         ContextManager,
--#         Dictionary,
--#         ErrorHandler,
--#         ExaminerConstants,
--#         E_Strings,
--#         FileSystem,
--#         IndexManager,
--#         LexTokenLists,
--#         LexTokenManager,
--#         ScreenEcho,
--#         SparkLex,
--#         SPARK_IO,
--#         SP_Symbols,
--#         STree,
--#         SystemErrors;

package ContextManager.Ops
--# own File_Heap  : File_Heaps;
--#     Unit_Heap  : Unit_Heaps;
--#     Unit_Stack : Unit_Stacks;
--# initializes File_Heap,
--#             Unit_Heap,
--#             Unit_Stack;
is

   procedure Open_File (File_Descriptor : in ContextManager.FileDescriptors);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out ErrorHandler.Error_Context;
   --#        in out File_Heap;
   --#        in out SparkLex.Curr_Line;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.Error_Context,
   --#         File_Heap,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         File_Descriptor,
   --#                                         File_Heap,
   --#                                         LexTokenManager.State,
   --#                                         SPARK_IO.File_Sys &
   --#         SparkLex.Curr_Line         from *,
   --#                                         File_Descriptor,
   --#                                         File_Heap,
   --#                                         LexTokenManager.State,
   --#                                         SPARK_IO.File_Sys;

   procedure Close_File (File_Descriptor : in ContextManager.FileDescriptors);
   --# global in out File_Heap;
   --#        in out SPARK_IO.File_Sys;
   --# derives File_Heap,
   --#         SPARK_IO.File_Sys from *,
   --#                                File_Descriptor,
   --#                                File_Heap;

   function Current_Unit return  ContextManager.UnitDescriptors;
   --# global in Unit_Stack;

   function Get_Unit_Status (Unit_Descriptor : ContextManager.UnitDescriptors) return ContextManager.UnitStatus;
   --# global in Unit_Heap;

   procedure Create_Unit_Descriptor
     (File_Descriptor : in     ContextManager.FileDescriptors;
      Unit_Descriptor :    out ContextManager.UnitDescriptors);
   --# global in out File_Heap;
   --#        in out Unit_Heap;
   --# derives File_Heap,
   --#         Unit_Heap       from *,
   --#                              File_Descriptor,
   --#                              File_Heap &
   --#         Unit_Descriptor from Unit_Heap;

   function Get_File_Descriptor (Unit_Descriptor : ContextManager.UnitDescriptors) return ContextManager.FileDescriptors;
   --# global in Unit_Heap;

   procedure SetUnitStatus (Descriptor : in ContextManager.UnitDescriptors;
                            Status     : in ContextManager.UnitStatus);
   --# global in out Unit_Heap;
   --# derives Unit_Heap from *,
   --#                        Descriptor,
   --#                        Status;

   function GetFileStatus (Descriptor : ContextManager.FileDescriptors) return ContextManager.FileStatus;
   --# global in File_Heap;

   procedure SetVCG (Descriptor : in ContextManager.UnitDescriptors;
                     VCG        : in Boolean);
   --# global in out Unit_Heap;
   --# derives Unit_Heap from *,
   --#                        Descriptor,
   --#                        VCG;

   procedure GetVCG (Descriptor : in     ContextManager.UnitDescriptors;
                     VCG        :    out Boolean);
   --# global in Unit_Heap;
   --# derives VCG from Descriptor,
   --#                  Unit_Heap;

   procedure GetUnitByName
     (UnitName    : in     LexTokenLists.Lists;
      UnitTypeSet : in     ContextManager.UnitTypeSets;
      Descriptor  :    out ContextManager.UnitDescriptors);
   --# global in LexTokenManager.State;
   --#        in Unit_Heap;
   --# derives Descriptor from LexTokenManager.State,
   --#                         UnitName,
   --#                         UnitTypeSet,
   --#                         Unit_Heap;

   procedure SetUnitName
     (Descriptor : in ContextManager.UnitDescriptors;
      UnitName   : in LexTokenLists.Lists;
      UnitType   : in ContextManager.UnitTypes);
   --# global in out Unit_Heap;
   --# derives Unit_Heap from *,
   --#                        Descriptor,
   --#                        UnitName,
   --#                        UnitType;

   procedure GetUnitName
     (Descriptor : in     ContextManager.UnitDescriptors;
      UnitName   :    out LexTokenLists.Lists;
      UnitType   :    out ContextManager.UnitTypes);
   --# global in Unit_Heap;
   --# derives UnitName,
   --#         UnitType from Descriptor,
   --#                       Unit_Heap;

   procedure SetParseTree (Descriptor : in ContextManager.UnitDescriptors;
                           ParseTree  : in STree.SyntaxNode);
   --# global in     STree.Table;
   --#        in out Unit_Heap;
   --# derives Unit_Heap from *,
   --#                        Descriptor,
   --#                        ParseTree,
   --#                        STree.Table;

   procedure GetParseTree (Descriptor : in     ContextManager.UnitDescriptors;
                           ParseTree  :    out STree.SyntaxNode);
   --# global in Unit_Heap;
   --# derives ParseTree from Descriptor,
   --#                        Unit_Heap;

   procedure MarkUnitInCycle (Descriptor : in ContextManager.UnitDescriptors);
   --# global in out Unit_Heap;
   --# derives Unit_Heap from *,
   --#                        Descriptor;

   function UnitInCycle (Descriptor : ContextManager.UnitDescriptors) return Boolean;
   --# global in Unit_Heap;
   function FirstUnitDescriptor return  ContextManager.UnitDescriptors;
   --# global in Unit_Heap;
   function NextUnitDescriptor (Descriptor : ContextManager.UnitDescriptors) return ContextManager.UnitDescriptors;
   --# global in Unit_Heap;
   procedure PushUnit (Descriptor : in ContextManager.UnitDescriptors);
   --# global in out Unit_Stack;
   --# derives Unit_Stack from *,
   --#                         Descriptor;

   procedure PopUnit (Descriptor : out ContextManager.UnitDescriptors);
   --# global in out Unit_Stack;
   --# derives Descriptor,
   --#         Unit_Stack from Unit_Stack;

   procedure CreateFileDescriptor (Descriptor : out ContextManager.FileDescriptors);
   --# global in out File_Heap;
   --# derives Descriptor,
   --#         File_Heap  from File_Heap;

   procedure SetSourceFileName (Descriptor     : in ContextManager.FileDescriptors;
                                SourceFileName : in LexTokenManager.Lex_String);
   --# global in out File_Heap;
   --# derives File_Heap from *,
   --#                        Descriptor,
   --#                        SourceFileName;

   function GetSourceFileName (Descriptor : in ContextManager.FileDescriptors) return LexTokenManager.Lex_String;
   --# global in File_Heap;

   procedure GetSourceFile (Descriptor : in     ContextManager.FileDescriptors;
                            SourceFile :    out SPARK_IO.File_Type);
   --# global in File_Heap;
   --# derives SourceFile from Descriptor,
   --#                         File_Heap;

   function ListingReqt (Descriptor : ContextManager.FileDescriptors) return Boolean;
   --# global in File_Heap;
   function FirstFileDescriptor return  ContextManager.FileDescriptors;
   --# global in File_Heap;
   function NextFileDescriptor (Descriptor : ContextManager.FileDescriptors) return ContextManager.FileDescriptors;
   --# global in File_Heap;

   function GetFileByName (FileName : in LexTokenManager.Lex_String) return ContextManager.FileDescriptors;
   --# global in File_Heap;
   --#        in LexTokenManager.State;

   procedure SetFileStatus (Descriptor : in ContextManager.FileDescriptors;
                            Status     : in ContextManager.FileStatus);
   --# global in out File_Heap;
   --# derives File_Heap from *,
   --#                        Descriptor,
   --#                        Status;

   procedure SetListingReq (Descriptor : in ContextManager.FileDescriptors;
                            Req        : in Boolean);
   --# global in out File_Heap;
   --# derives File_Heap from *,
   --#                        Descriptor,
   --#                        Req;

   procedure SetLineContext (Descriptor  : in ContextManager.FileDescriptors;
                             FileContext : in SparkLex.Line_Context);
   --# global in out File_Heap;
   --# derives File_Heap from *,
   --#                        Descriptor,
   --#                        FileContext;

   procedure GetLineContext (Descriptor  : in     ContextManager.FileDescriptors;
                             FileContext :    out SparkLex.Line_Context);
   --# global in File_Heap;
   --# derives FileContext from Descriptor,
   --#                          File_Heap;

   procedure SetErrorContext (Descriptor : in ContextManager.FileDescriptors;
                              Context    : in ErrorHandler.Error_Contexts);
   --# global in out File_Heap;
   --# derives File_Heap from *,
   --#                        Context,
   --#                        Descriptor;

   procedure GetErrorContext (Descriptor : in     ContextManager.FileDescriptors;
                              Context    :    out ErrorHandler.Error_Contexts);
   --# global in File_Heap;
   --# derives Context from Descriptor,
   --#                      File_Heap;

   procedure SetListingFileName (Descriptor        : in ContextManager.FileDescriptors;
                                 Listing_File_Name : in E_Strings.T);
   --# global in out File_Heap;
   --# derives File_Heap from *,
   --#                        Descriptor,
   --#                        Listing_File_Name;

   procedure GetListingFileName (Descriptor        : in     ContextManager.FileDescriptors;
                                 Listing_File_Name :    out E_Strings.T);
   --# global in File_Heap;
   --# derives Listing_File_Name from Descriptor,
   --#                                File_Heap;

   procedure SetErrorsReported (Descriptor : in ContextManager.FileDescriptors);
   --# global in out File_Heap;
   --# derives File_Heap from *,
   --#                        Descriptor;

   function ErrorsReported (Descriptor : ContextManager.FileDescriptors) return Boolean;
   --# global in File_Heap;

   --  Find the compilation unit descriptor associated with the file
   --  descriptor (Descriptor). Each compilation unit has only one
   --  file but each file can contain many compilation units. This
   --  function must only be used for the SLI generation because, in
   --  the case of GNAT source code, each file has only one
   --  compilation unit.
   procedure Get_Unit (Descriptor      : in     ContextManager.FileDescriptors;
                       Unit_Descriptor :    out ContextManager.UnitDescriptors);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in     Unit_Heap;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Descriptor,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table,
   --#                                         Unit_Heap &
   --#         Unit_Descriptor            from Descriptor,
   --#                                         Unit_Heap;

   --  Get the parent of an Ada separate unit (Unit_Descriptor).
   procedure Get_Parent (Unit_Descriptor : in out ContextManager.UnitDescriptors);
   --# global in LexTokenManager.State;
   --#        in Unit_Heap;
   --# derives Unit_Descriptor from *,
   --#                              LexTokenManager.State,
   --#                              Unit_Heap;

   --  The procedure marks all the compilation units that are in the
   --  closure of the compilation unit associated with the file
   --  descriptor (Descriptor). Each compilation unit has only one
   --  file but each file can contain many compilation units. This
   --  function must only be used for the SLI generation because, in
   --  the case of GNAT source code, each file has only one
   --  compilation unit. This procedure must be called before the
   --  function In_Closure.
   procedure Dependency_Closure (Descriptor : in ContextManager.FileDescriptors);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     STree.Table;
   --#        in out ErrorHandler.Error_Context;
   --#        in out IndexManager.State;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Unit_Heap;
   --# derives ErrorHandler.Error_Context,
   --#         IndexManager.State,
   --#         LexTokenManager.State,
   --#         SPARK_IO.File_Sys,
   --#         Unit_Heap                  from CommandLineData.Content,
   --#                                         Descriptor,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         IndexManager.State,
   --#                                         LexTokenManager.State,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table,
   --#                                         Unit_Heap;

   --  Return TRUE if the compilation unit descriptor (Descriptor) is
   --  in the closure of the compilation unit calculated by
   --  Dependency_Closure. The procedure Dependency_Closure must be
   --  called before this function.
   function In_Closure (Descriptor : in ContextManager.UnitDescriptors) return Boolean;
   --# global in Unit_Heap;

   --  Set the line number of the "D ..." line (see D section of the
   --  ALI format).
   procedure Set_Line_Number (Descriptor  : in ContextManager.UnitDescriptors;
                              Line_Number : in Positive);
   --# global in out Unit_Heap;
   --# derives Unit_Heap from *,
   --#                        Descriptor,
   --#                        Line_Number;

   --  Get the line number of the "D ..." line (see D section of the
   --  ALI format).
   function Get_Line_Number (Descriptor : in ContextManager.UnitDescriptors) return Natural;
   --# global in Unit_Heap;

end ContextManager.Ops;
