-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

-------------------------------------------------------------------------------
--                                                                           --
-- SPARK.Ada.Strings.Maps.Not_SPARK                                          --
--                                                                           --
-- Description                                                               --
--   This package provides the features of Ada.Strings.Maps which are not    --
--   compatible with SPARK. Please refer to the Ada LRM description of       --
--   Ada.Strings.Maps for usage information.                                 --
--                                                                           --
-------------------------------------------------------------------------------

with Ada.Strings.Maps;

package SPARK.Ada.Strings.Maps.Not_SPARK is

   type Character_Ranges is new Standard.Ada.Strings.Maps.Character_Ranges;

   function To_Set    (Ranges : Character_Ranges) return Character_Set;

   function To_Ranges (Set : Character_Set)       return Character_Ranges;

   function "<="
     (Left  : Character_Set;
      Right : Character_Set) return Boolean
   renames Is_Subset;

   subtype Character_Sequence is String;
   --  Alternative representation for a set of character values

   function To_Sequence (Set : Character_Set) return Character_Sequence;

   function To_Domain
     (Map : Character_Mapping) return Character_Sequence;

   function To_Range
     (Map : Character_Mapping) return Character_Sequence;

   type Character_Mapping_Function is
     new Standard.Ada.Strings.Maps.Character_Mapping_Function;

   ------------------------------------------------
   -- Conversion functions from SPARK.Ada to Ada --
   ------------------------------------------------

   function To_Character_Set
     (From : Character_Set)
     return Standard.Ada.Strings.Maps.Character_Set;
   function To_Character_Range
     (From : Character_Range)
     return Standard.Ada.Strings.Maps.Character_Range;
   function To_Character_Mapping
     (From : Character_Mapping)
     return Standard.Ada.Strings.Maps.Character_Mapping;

end SPARK.Ada.Strings.Maps.Not_SPARK;
