/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.common.math.Math;
import cds.healpix.common.math.TaylorSeries;

abstract class AngularDistanceComputer {
    AngularDistanceComputer() {
    }

    protected abstract double cos(double var1);

    protected abstract double sin(double var1);

    protected abstract double asin(double var1);

    public final double haversineDistInRad(double deltaLonRad, double deltaLatRad, double cosLatA, double cosLatB) {
        return 2.0 * this.asin(java.lang.Math.sqrt(this.squareOfsinOfhalfDistInRad2(deltaLonRad, deltaLatRad, cosLatA, cosLatB)));
    }

    public final double squareOfsinOfhalfDistInRad2(double deltaLonRad, double deltaLatRad, double cosLatA, double cosLatB) {
        double d = this.sin(0.5 * deltaLatRad);
        double a = this.sin(0.5 * deltaLonRad);
        return d * d + a * a * cosLatA * cosLatB;
    }

    public final double coneDeltaLon(double squareOfSinOfHalfRadius, double cosOfConeCentreLat, double deltaLatRad, double sinLat) {
        double d = java.lang.Math.sqrt(1.0 - sinLat * sinLat) * cosOfConeCentreLat;
        double n = this.sin(0.5 * deltaLatRad);
        if ((n = squareOfSinOfHalfRadius - n * n) < 0.0) {
            return Double.NaN;
        }
        if (n >= d) {
            return java.lang.Math.PI;
        }
        return 2.0 * this.asin(java.lang.Math.sqrt(n / d));
    }

    public static final AngularDistanceComputer getComputer(double angleScaleInRad) {
        assert (angleScaleInRad >= 0.0);
        if (angleScaleInRad <= 1.0E-5) {
            return new AngularDistanceComputer(){

                @Override
                protected double cos(double x) {
                    return x < 1.0E-4 ? TaylorSeries.cosO2(x) : Math.cos(x);
                }

                @Override
                protected double sin(double x) {
                    return x < 1.0E-4 ? TaylorSeries.sinO3(x) : Math.sin(x);
                }

                @Override
                protected double asin(double x) {
                    return x < 1.0E-4 ? TaylorSeries.asinO3(x) : Math.asin(x);
                }
            };
        }
        if (angleScaleInRad <= 0.001) {
            return new AngularDistanceComputer(){

                @Override
                protected double cos(double x) {
                    return x < 0.01 ? TaylorSeries.cosO4(x) : Math.cos(x);
                }

                @Override
                protected double sin(double x) {
                    return x < 0.01 ? TaylorSeries.sinO5(x) : Math.sin(x);
                }

                @Override
                protected double asin(double x) {
                    return x < 0.01 ? TaylorSeries.asinO5(x) : Math.asin(x);
                }
            };
        }
        if (angleScaleInRad <= 0.01) {
            return new AngularDistanceComputer(){

                @Override
                protected double cos(double x) {
                    return x < 0.05 ? TaylorSeries.cosO6(x) : Math.cos(x);
                }

                @Override
                protected double sin(double x) {
                    return x < 0.05 ? TaylorSeries.sinO7(x) : Math.sin(x);
                }

                @Override
                protected double asin(double x) {
                    return x < 0.05 ? TaylorSeries.asinO7(x) : Math.asin(x);
                }
            };
        }
        return new AngularDistanceComputer(){

            @Override
            protected double cos(double x) {
                return Math.cos(x);
            }

            @Override
            protected double sin(double x) {
                return Math.sin(x);
            }

            @Override
            protected double asin(double x) {
                return Math.asin(x);
            }
        };
    }
}

