/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix.common.sphgeom;

import cds.healpix.common.math.Math;
import cds.healpix.common.sphgeom.CooXYZ;
import cds.healpix.common.sphgeom.Vect3D;

public final class Polygon {
    private static final CooXYZ NORTH_POLE = new CooXYZ(java.lang.Math.PI, 1.5707963267948966);
    private final CooXYZ[] vertices;
    private final Vect3D[] vectProds;
    private final boolean containsSouthPole;

    public Polygon(CooXYZ[] polyVertices) {
        this(polyVertices, ContainsSouthPoleComputer.BASIC);
    }

    public Polygon(CooXYZ[] polyVertices, ContainsSouthPoleComputer cspc) {
        if (polyVertices.length < 3) {
            throw new IllegalArgumentException("A polygon must have a minimum of 3 vertices!");
        }
        this.vertices = polyVertices;
        this.vectProds = new Vect3D[this.vertices.length];
        int i = 0;
        int j = this.vertices.length - 1;
        while (i < this.vertices.length) {
            Vect3D xprod = CooXYZ.crossProd(this.vertices[i], this.vertices[j]);
            this.vectProds[i] = xprod.z() < 0.0 ? xprod.opposite() : xprod;
            j = i++;
        }
        this.containsSouthPole = cspc.containsSouthPole(polyVertices, this.vectProds);
    }

    public int nVertices() {
        return this.vertices.length;
    }

    public CooXYZ vertex(int vertexIndex) {
        return this.vertices[vertexIndex];
    }

    public boolean contains(CooXYZ p) {
        return this.containsSouthPole ^ this.oddNumberOfIntersectionGoingSouth(p);
    }

    private boolean oddNumberOfIntersectionGoingSouth(CooXYZ p) {
        boolean c = false;
        int i = 0;
        int j = this.vertices.length - 1;
        while (i < this.vertices.length) {
            if (Polygon.isInLonRange(p, this.vertices[j], this.vertices[i]) && Polygon.crossPlaneGoingSouth(p, this.vectProds[i])) {
                c = !c;
            }
            j = i++;
        }
        return c;
    }

    private static boolean oddNumberOfIntersectionGoingSouth(CooXYZ p, CooXYZ[] vertices, Vect3D[] normals) {
        boolean c = false;
        int i = 0;
        int j = vertices.length - 1;
        while (i < vertices.length) {
            if (Polygon.isInLonRange(p, vertices[j], vertices[i]) && Polygon.crossPlaneGoingSouth(p, normals[i])) {
                c = !c;
            }
            j = i++;
        }
        return c;
    }

    private static boolean isInLonRange(CooXYZ p, CooXYZ v1, CooXYZ v2) {
        double dlon = v2.lon() - v1.lon();
        return dlon < 0.0 ? dlon >= -java.lang.Math.PI == (v2.lon() <= p.lon() && p.lon() < v1.lon()) : dlon <= java.lang.Math.PI == (v1.lon() <= p.lon() && p.lon() < v2.lon());
    }

    private static boolean crossPlaneGoingSouth(CooXYZ p, Vect3D planeNormalDirInNorthHemisphere) {
        return p.scalarProd(planeNormalDirInNorthHemisphere) > 0.0;
    }

    public boolean intersectSegAB(CooXYZ a, CooXYZ b) {
        if (a.lon() > b.lon()) {
            CooXYZ swp = a;
            a = b;
            b = swp;
        }
        int i = 0;
        int j = this.vertices.length - 1;
        while (i < this.vertices.length) {
            double ub;
            double ua;
            CooXYZ pA = this.vertices[i];
            CooXYZ pB = this.vertices[j];
            if (pA.lon() > pB.lon()) {
                CooXYZ swp = pA;
                pA = pB;
                pB = swp;
            }
            if (Polygon.segmentsAreOverlappingInLon(a, b, pA, pB) && Polygon.polygonEdgeIntersectsGreatCircle(ua = a.scalarProd(this.vectProds[i]), ub = b.scalarProd(this.vectProds[i])) && Polygon.intersectPointInPolygonSegment(a, b, pA, pB, ua, ub)) {
                return true;
            }
            j = i++;
        }
        return false;
    }

    private static boolean segmentsAreOverlappingInLon(CooXYZ a, CooXYZ b, CooXYZ pA, CooXYZ pB) {
        boolean b2;
        boolean b1 = b.lon() - a.lon() <= java.lang.Math.PI;
        boolean bl = b2 = pB.lon() - pA.lon() <= java.lang.Math.PI;
        return b1 ? (b2 ? pB.lon() >= a.lon() && pA.lon() <= b.lon() : pB.lon() <= b.lon() || pA.lon() >= a.lon()) : (b2 ? pB.lon() >= b.lon() || pA.lon() <= a.lon() : true);
    }

    private static boolean polygonEdgeIntersectsGreatCircle(double aDotProdEdgeN, double bDotProdEdgeN) {
        return aDotProdEdgeN > 0.0 != bDotProdEdgeN > 0.0;
    }

    private static boolean intersectPointInPolygonSegment(CooXYZ a, CooXYZ b, CooXYZ pA, CooXYZ pB, double aDotProdEdgeN, double bDotProdEdgeN) {
        Vect3D intersect = Polygon.normalizedIntersectPoint(a, b, aDotProdEdgeN, bDotProdEdgeN);
        double papb = pA.scalarProd(pB);
        return Math.abs(pA.scalarProd(intersect)) > papb && Math.abs(pB.scalarProd(intersect)) > papb;
    }

    private static Vect3D normalizedIntersectPoint(CooXYZ a, CooXYZ b, double aDotProdEdgeN, double bDotProdEdgeN) {
        double x = bDotProdEdgeN * a.x() - aDotProdEdgeN * b.x();
        double y = bDotProdEdgeN * a.y() - aDotProdEdgeN * b.y();
        double z = bDotProdEdgeN * a.z() - aDotProdEdgeN * b.z();
        double norm = Math.sqrt(x * x + y * y + z * z);
        return new Vect3D(x / norm, y / norm, z / norm);
    }

    public static enum ContainsSouthPoleComputer {
        PROVIDED_TRUE{

            @Override
            boolean containsSouthPole(CooXYZ[] vertices, Vect3D[] normals) {
                return true;
            }
        }
        ,
        PROVIDED_FALSE{

            @Override
            boolean containsSouthPole(CooXYZ[] vertices, Vect3D[] normals) {
                return true;
            }
        }
        ,
        BASIC{

            @Override
            boolean containsSouthPole(CooXYZ[] vertices, Vect3D[] normals) {
                int nVertexInSouthHemiSphere = 0;
                double sumDeltaLon = 0.0;
                int i = 0;
                int j = vertices.length - 1;
                while (i < vertices.length) {
                    double deltaLon = vertices[i].lon() - vertices[j].lon();
                    double absDeltaLon = Math.abs(deltaLon);
                    if (absDeltaLon <= java.lang.Math.PI) {
                        sumDeltaLon += deltaLon;
                    } else if (deltaLon > 0.0) {
                        sumDeltaLon -= java.lang.Math.PI * 2 - absDeltaLon;
                    } else {
                        assert (deltaLon < 0.0);
                        sumDeltaLon += java.lang.Math.PI * 2 - absDeltaLon;
                    }
                    if (vertices[i].lat() < 0.0) {
                        ++nVertexInSouthHemiSphere;
                    }
                    j = i++;
                }
                return Math.abs(sumDeltaLon) > java.lang.Math.PI && nVertexInSouthHemiSphere << 1 > vertices.length;
            }
        }
        ,
        STD_FXP{

            @Override
            boolean containsSouthPole(CooXYZ[] vertices, Vect3D[] normals) {
                Vect3D firstEdgeNormal = CooXYZ.crossProd(vertices[0], vertices[1]);
                int i = 1;
                while (Math.abs(vertices[++i].scalarProd(firstEdgeNormal)) < 1.0E-10) {
                }
                CooXYZ triangleCenter = CooXYZ.normalizedSum(vertices[0], vertices[1], vertices[i]);
                return triangleCenter.scalarProd(firstEdgeNormal) > 0.0 ^ Polygon.oddNumberOfIntersectionGoingSouth(new CooXYZ(triangleCenter.x(), triangleCenter.y(), triangleCenter.z()), vertices, normals);
            }
        }
        ,
        STD_IVOA{

            @Override
            boolean containsSouthPole(CooXYZ[] vertices, Vect3D[] normals) {
                throw new Error("Not implemented yet!");
            }
        };


        abstract boolean containsSouthPole(CooXYZ[] var1, Vect3D[] var2);
    }
}

