use core;
use core:debug;

class Base {
	Int a;

	Int overload() {
		a;
	}

	Int sum() {
		a;
	}

	protected Int prot() {
		10;
	}

	Int useProt() {
		prot();
	}

	private Int priv() {
		10;
	}

	Int usePriv() {
		priv();
	}

	private Int secret() {
		22;
	}

	class Inner {
		public Int z;

		Int value(Base other) {
			z + other.secret + other.a;
		}
	}
}

class Derived extends Base {
	Int b;

	Int overload() {
		b;
	}

	Int sum() {
		super:sum + b;
	}

	protected Int prot() {
		20;
	}

	private Int priv() {
		20;
	}

	Int callSecret() {
		secret();
	}

	private Int secret() {
		// Should not compile.
		super:secret();
	}
}

Int extract(Base b) {
	b.overload;
}

Int testBase() {
	Base b = Base();
	// printVTable(b);
	b.a = 10;
	extract(b);
}

Int testDerived() {
	Derived d = Derived();
	// printVTable(d);
	d.a = 10;
	d.b = 20;
	extract(d);
}

Int testSuperExpr() {
	Derived d = Derived();
	d.a = 10;
	d.b = 20;
	d.sum;
}

Int asExpr(Base v) {
	if (v as Derived) {
		v.a + v.b;
	} else {
		v.a;
	}
}

Int testAsExpr(Int v) {
	if (v == 1) {
		Base z;
		z.a = 12;
		asExpr(z);
	} else {
		Derived z;
		z.a = 10;
		z.b = 20;
		asExpr(z);
	}
}

Int asExpr2(Base v) {
	if (q = v as Derived) {
		q.a + q.b;
	} else {
		v.a;
	}
}

Int testAsExpr2(Int v) {
	if (v == 1) {
		Base z;
		z.a = 12;
		asExpr2(z);
	} else {
		Derived z;
		z.a = 10;
		z.b = 20;
		asExpr2(z);
	}
}

Int testAccess(Int type, Int fn) {
	Base c = if (type == 0) { Base(); } else { Derived(); };

	if (fn == 0) {
		c.usePriv();
	} else {
		c.useProt();
	}
}

Int testCallProt() {
	Base b;
	// Should not compile.
	b.prot();
}

Int testCallPriv() {
	Base b;
	// Should not compile.
	b.priv();
}

Int testPrivSuper() {
	Derived d;
	d.callSecret();
}

Int testInner() {
	Base b;
	b.a = 1;

	Base:Inner i;
	i.z = 2;

	i.value(b);
}

class DerivedDbg extends Dbg {
	Int b;

	init() {
		init() {}
	}

	init(Int a) {
		init() { b = a; }
	}

	Int get() {
		b;
	}
}

Int extract(Dbg b) {
	b.get;
}

DerivedDbg derived() {
	DerivedDbg d = DerivedDbg();
	d.b = 20;
	d;
}

Dbg createCpp(Int type) {
	if (type == 1) {
		Dbg();
	} else {
		derived();
	}
}

Int testCpp(Int type) {
	Dbg b = createCpp(type);
	extract(b);
}


Int overloaded(Dbg base) {
	1;
}

Int overloaded(DerivedDbg derived) {
	2;
}

Int testOverload(Int id) {
	if (id == 1) {
		overloaded(Dbg(1));
	} else {
		overloaded(DerivedDbg());
	}
}
