use presentation;
use presentation:graph;
use ui;
use core:geometry;
use core:io;
use graphics;
use layout;
use lang:bs:macro;

Url resUrl() {
	if (u = named{res}.url) {
		u;
	} else {
		Url();
	}
}

// A 'style' used in a picture...
void myBox(Node n) on Render {
	n.margin(10, 10);
}

presentation Test "Test presentation" {
	Font font("Arial", 32);

	animationTime = 500 ms;

	background Stack {
		SolidFill white {}
		anchor southEast {
			pageNumber {}
		}
	}

	slide FadeIn => title "Test presentation", "My name here!" {}

	slide FadeIn => content "Testing!" {
		SolidFill green {}
	}

	slide SlideDown false => columns "Two columns!" {
		SolidFill green { @1, 1 s: FadeIn; }
		SolidFill blue { @1 +500 ms, 1 s: FadeIn; }
	}

	slide SlideDown false => content "Drawn pictures!" {
		picture {
			picture.scale = 1;

			a = rectangle { myBox; text: "Hello!"; fillColor: red; }
			b = rectangle { east: 0 of a; myBox; text: "World!"; fillColor: green; }
			node { south: 0 of b.southWest; text: "I am below!"; }

			r = rectangle { myBox; rounded: 10; text: "Above!"; north: 20 of a.northEast; }
			ca = circle { text: "23"; north: 20 of r.northWest - Size(60, 0); }
			cb = circle { oval; text: "Longer"; north: 20 of r.northEast + Size(60, 0); fillColor: green + blue; }
			cd = rectangle { myBox; text: "Above"; north: 100 of r; @1, 1s: FadeIn; }

			edge ca, cb { bendLeft: 0.1; toArrow: PlainArrow; @3: Show; }
			edge cd, cb { fromArrow: TriangleArrow; toArrow: PlainArrow; }
			edge ca, cd { fromArrow: FancyArrow; toArrow: FancyArrow; @2, 1s: FadeIn; }
		}
	}

	slide SlideDown true => columns "Text as well!" {
		par "A single long paragraph in this column." {}
		Stack {
			SolidFill green {}
			list ["Second column!", "Contains a list!", "Of nice elements!"] {}
		}
	}

	slide SlideDown false => columns "Various lists..." {
		list ["Unordered list", "Foo", "Bar", "Baz"] {}
		Stack {
			SolidFill green {}
			list ["Ordered list", "Foo", "Bar", "Baz"] { ordered; }
		}
	}

	slide SlideDown false => content "Image!" {
		image resUrl / "flower-raw.ppm" { fit; }
	}

	slide Enlarge => Grid {
	expandCol: 0;
	expandCol: 1;
	expandRow: 1;
		Heading "Neat colored boxes!", font, black { colspan: 2; }
		nextLine;
		SolidFill RadialGradient(red, white, Point(320, 240), 300) {}
		SolidFill RadialGradient(green, white, Point(320, 240), 300) {}
	}

	slide Enlarge => content "Bar graphs!" {
		barGraph {
		labels: ["A", "B", "C", "D"];
		ticks: 0, 10, 40;
		data: [10, 20, 30, 8], red;
		data: [12, 14, 40, 10], green;
		dataLabels: (x) => "${x}%";

		@1: ShowLabel 1;
		@1+400ms: ShowLabel 2;
		@2: HideLabel 1;
		@3: ShowLabel 3;
		@4: HideLabel 3;
		}
	}
}


// Main entry-point for testing.
void test() {
	// export(Test, cwdUrl / ".." / "presentation.pdf");
	Test.show();
}
