/* ====================================================================
 * Copyright (c) 2008-2009  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _WCVIEWITEMTEST_H
#define _WCVIEWITEMTEST_H

// sc
#include "subcommander/WcViewItem.h"
#include "util/String.h"

enum WcViewItemType {
  WcViewItemTypeFile,
  WcViewItemTypeDir
};

enum WcViewItemState {
  WcViewItemStateNormal,
  WcViewItemStateChanged
};

/** simple WcViewItem implementation. */
class WcViewItemTest : public WcViewItem
{
public:
  // obsolete constructor
  WcViewItemTest( const sc::String& name, bool dir, bool changed );
  WcViewItemTest( const sc::String& name, WcViewItemType type,
    WcViewItemState state );

  const sc::String& path() const;
  bool isDir() const;

  bool isChanged() const;
  bool isIgnored() const;
  bool isSwitched() const;
  bool isOutOfDate() const;

  StatusId getTextStatus() const;

private:
  sc::String      _name;
  WcViewItemType  _type;
  WcViewItemState _state;
};

WcViewItemPtr createItem( const char* name, WcViewItemType type,
  WcViewItemState state );

class WcViewItemDataTest : public WcViewItemData
{
public:
  WcViewItemDataTest ();
  WcViewItemDataTest (int columns);

  int columns() const;
  QString data( int column, const WcViewItem* ) const;
  QColor color( int column, const WcViewItem* ) const;
  QVariant dataSort( int column, const WcViewItem* ) const;
  QString header( int column ) const;
  Qt::Alignment alignment( int column ) const;
  bool deep( int column ) const;

private:
  int _columns;
};

#endif // _WCVIEWITEMTEST_H
