/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_SYNCCMDRESULT_H
#define _SC_SYNCCMDRESULT_H

// sc
#include "commands/CmdResultCallback.h"
class ScParam;

namespace svn
{
  class Error;
}


/**
 * CmdResultCallback implementation that only stores the param object
 * and a possible error object.
 */
class SyncCmdResult : public CmdResultCallback
{
public:
  void handleResult( ScParam* p, const sc::Error* e )
  {
    _param = p;
    _err   = e;
  }

  const sc::Error* getError()
  {
    return _err;
  }

  ScParam* getParam()
  {
    return _param;
  }

private:
  ScParam*         _param;
  const sc::Error* _err;
};

#endif // _SC_SYNCCMDRESULT_H
