/* ====================================================================
 * Copyright 2008  Martin Hauner
 *                 http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_WCVIEWPROGRESS_H
#define _SC_WCVIEWPROGRESS_H

// sc
#include "commands/CmdProgressCallback.h"

// qt
class QObject;

/**
 * WcView CmdProgressCallback implementation. It is called at the
 * beginning and at the end of a command. This is *no* progress info
 * from subversion.
 */
class WcViewCmdProgress : public CmdProgressCallback
{
public:
  WcViewCmdProgress( QObject* target );

  // CmdProgressCallback
  void started( ScParam*, Cancel* );
  void finished( ScParam*, double );

  // hack :(
  QObject* getTarget() { return _target; }

private:
  QObject* _target;
};

#endif // _SC_WCVIEWPROGRESS_H
