/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_INFOPARAM_H
#define _SC_INFOPARAM_H

// sc
#include "ScParam.h"
#include "util/String.h"
#include "svn/Revision.h"
#include "svn/InfoBaton.h"


/**
 * Parameter class for InfoCmd.
 */
class InfoParam : public ScParam
{
public:
  InfoParam( 
    const sc::String& pathOrUrl, const svn::Revision* rev,
    const svn::Revision* peg, bool recurse, svn::InfoBaton* baton )
    : _pathOrUrl(pathOrUrl), _rev(rev), _peg(peg), _recurse(recurse),
      _baton(baton)
  {
  }

  ~InfoParam()
  {
    delete _rev;
    delete _peg;
    delete _baton;
  }

  bool isPeg() const
  {
    return _peg != 0;
  }

  const sc::String& getPathOrUrl() const
  {
    return _pathOrUrl;
  }

  const svn::Revision* getRevision() const
  {
    return _rev;
  }

  const svn::Revision* getPegRevision() const
  {
    return _peg;
  }

  bool getRecurse() const
  {
    return _recurse;
  }

  svn::InfoBaton* getBaton() const
  {
    return _baton;
  }

  ScParamAccept(InfoParam);

private:
  // in
  sc::String           _pathOrUrl;
  const svn::Revision* _rev;
  const svn::Revision* _peg;
  bool                 _recurse;
  svn::InfoBaton*      _baton;
};

#endif // _SC_INFOPARAM_H
