/* ====================================================================
 * Copyright (c) 2003-2006, 2008  Martin Hauner
 *                                http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_MOVEPARAM_H
#define _SC_MOVEPARAM_H

// sc
#include "ScParam.h"
#include "svn/ClientTypes.h"
#include "svn/CommitInfo.h"
#include "util/String.h"


/** Parameter class for MoveCmd. */
class MoveParam : public ScParam
{
public:
  MoveParam( const svn::Paths& srcPathsOrUrls, const svn::Paths& dstPathsOrUrls,
    bool force ) : _srcPathsOrUrls(srcPathsOrUrls), _dstPathsOrUrls(dstPathsOrUrls),
    _force(force)
  {
  }

  const svn::Paths& getSrcPathsOrUrls() const
  {
    return _srcPathsOrUrls;
  }

  const svn::Paths& getDstPathsOrUrls() const
  {
    return _dstPathsOrUrls;
  }

  bool getForce() const
  {
    return _force;
  }

  svn::CommitInfo& getCommitInfo()
  {
    return _info;
  }

  ScParamAccept(MoveParam);

private:
  // in
  svn::Paths      _srcPathsOrUrls;
  svn::Paths      _dstPathsOrUrls;
  bool            _force;

  // out
  svn::CommitInfo _info;
};

#endif // _SC_MOVEPARAM_H
