/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "Lock.h"

// svn
#include <svn_types.h>


namespace svn
{

Lock::Lock( const svn_lock_t* lock )
{
  _path           = lock->path;
  _token          = lock->token;
  _owner          = lock->owner;
  _comment        = lock->comment;
  _creationDate   = lock->creation_date;
  _expirationDate = lock->expiration_date;
}

const sc::String& Lock::getPath() const
{
  return _path;
}

const sc::String& Lock::getToken() const
{
  return _token;
}

const sc::String& Lock::getOwner() const
{
  return _owner;
}

const sc::String& Lock::getComment() const
{
  return _comment;
}

Date Lock::getCreationDate() const
{
  return _creationDate;
}

Date Lock::getExpirationDate() const
{
  return _expirationDate;
}


} // namespace
